/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Set;
import net.nemerosa.ontrack.model.security.ProjectFunction;

public class ProjectRole
implements Serializable {
    private final String id;
    private final String name;
    private final String description;
    private final Set<Class<? extends ProjectFunction>> functions;

    public boolean isGranted(Class<? extends ProjectFunction> functionToCheck) {
        return this.functions.stream().anyMatch(functionToCheck::isAssignableFrom);
    }

    @ConstructorProperties(value={"id", "name", "description", "functions"})
    public ProjectRole(String id, String name, String description, Set<Class<? extends ProjectFunction>> functions) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.functions = functions;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Class<? extends ProjectFunction>> getFunctions() {
        return this.functions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectRole)) {
            return false;
        }
        ProjectRole other = (ProjectRole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<Class<? extends ProjectFunction>> this$functions = this.getFunctions();
        Set<Class<? extends ProjectFunction>> other$functions = other.getFunctions();
        return !(this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<Class<? extends ProjectFunction>> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectRole(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", functions=" + this.getFunctions() + ")";
    }
}

