/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Set;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.ProjectFunction;

public class GlobalRole
implements Serializable {
    private final String id;
    private final String name;
    private final String description;
    private final Set<Class<? extends GlobalFunction>> globalFunctions;
    private final Set<Class<? extends ProjectFunction>> projectFunctions;

    public boolean isGlobalFunctionGranted(Class<? extends GlobalFunction> fn) {
        return this.globalFunctions.contains(fn);
    }

    public boolean isProjectFunctionGranted(Class<? extends ProjectFunction> fn) {
        return this.projectFunctions.stream().anyMatch(fn::isAssignableFrom);
    }

    @ConstructorProperties(value={"id", "name", "description", "globalFunctions", "projectFunctions"})
    public GlobalRole(String id, String name, String description, Set<Class<? extends GlobalFunction>> globalFunctions, Set<Class<? extends ProjectFunction>> projectFunctions) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.globalFunctions = globalFunctions;
        this.projectFunctions = projectFunctions;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Class<? extends GlobalFunction>> getGlobalFunctions() {
        return this.globalFunctions;
    }

    public Set<Class<? extends ProjectFunction>> getProjectFunctions() {
        return this.projectFunctions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalRole)) {
            return false;
        }
        GlobalRole other = (GlobalRole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<Class<? extends GlobalFunction>> this$globalFunctions = this.getGlobalFunctions();
        Set<Class<? extends GlobalFunction>> other$globalFunctions = other.getGlobalFunctions();
        if (this$globalFunctions == null ? other$globalFunctions != null : !((Object)this$globalFunctions).equals(other$globalFunctions)) {
            return false;
        }
        Set<Class<? extends ProjectFunction>> this$projectFunctions = this.getProjectFunctions();
        Set<Class<? extends ProjectFunction>> other$projectFunctions = other.getProjectFunctions();
        return !(this$projectFunctions == null ? other$projectFunctions != null : !((Object)this$projectFunctions).equals(other$projectFunctions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<Class<? extends GlobalFunction>> $globalFunctions = this.getGlobalFunctions();
        result = result * 59 + ($globalFunctions == null ? 43 : ((Object)$globalFunctions).hashCode());
        Set<Class<? extends ProjectFunction>> $projectFunctions = this.getProjectFunctions();
        result = result * 59 + ($projectFunctions == null ? 43 : ((Object)$projectFunctions).hashCode());
        return result;
    }

    public String toString() {
        return "GlobalRole(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", globalFunctions=" + this.getGlobalFunctions() + ", projectFunctions=" + this.getProjectFunctions() + ")";
    }
}

