/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.support.Action;

public class ConnectedAccount {
    private final boolean authenticationRequired;
    private final Account account;
    private final List<Action> actions = new ArrayList<Action>();

    public static ConnectedAccount none(boolean authenticationRequired) {
        return new ConnectedAccount(authenticationRequired, null);
    }

    public static ConnectedAccount of(boolean authenticationRequired, Account account) {
        Entity.isEntityDefined(account, "Account must be defined");
        return new ConnectedAccount(authenticationRequired, account);
    }

    public boolean isLogged() {
        return this.account != null;
    }

    public ConnectedAccount add(Action action) {
        this.actions.add(action);
        return this;
    }

    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public Account getAccount() {
        return this.account;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectedAccount)) {
            return false;
        }
        ConnectedAccount other = (ConnectedAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthenticationRequired() != other.isAuthenticationRequired()) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectedAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthenticationRequired() ? 79 : 97);
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        List<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectedAccount(authenticationRequired=" + this.isAuthenticationRequired() + ", account=" + this.getAccount() + ", actions=" + this.getActions() + ")";
    }

    @ConstructorProperties(value={"authenticationRequired", "account"})
    protected ConnectedAccount(boolean authenticationRequired, Account account) {
        this.authenticationRequired = authenticationRequired;
        this.account = account;
    }
}

