/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.GlobalRole;
import net.nemerosa.ontrack.model.security.ProjectFunction;
import net.nemerosa.ontrack.model.security.ProjectRoleAssociation;

public class Authorisations
implements Serializable {
    private GlobalRole globalRole;
    private Set<ProjectRoleAssociation> projectRoleAssociations = new LinkedHashSet<ProjectRoleAssociation>();

    public static Authorisations none() {
        return new Authorisations(null, new LinkedHashSet<ProjectRoleAssociation>());
    }

    public boolean isGranted(Class<? extends GlobalFunction> fn) {
        return this.globalRole != null && this.globalRole.isGlobalFunctionGranted(fn);
    }

    public boolean isGranted(int projectId, Class<? extends ProjectFunction> fn) {
        return this.globalRole != null && this.globalRole.isProjectFunctionGranted(fn) || this.projectRoleAssociations.stream().anyMatch(pa -> pa.getProjectId() == projectId && pa.isGranted(fn));
    }

    public Authorisations withGlobalRole(Optional<GlobalRole> globalRole) {
        this.globalRole = globalRole.orElse(null);
        return this;
    }

    public Authorisations withProjectRoles(Collection<ProjectRoleAssociation> projectRoleAssociations) {
        this.projectRoleAssociations.addAll(projectRoleAssociations);
        return this;
    }

    public Authorisations withProjectRole(ProjectRoleAssociation projectRoleAssociation) {
        this.projectRoleAssociations.add(projectRoleAssociation);
        return this;
    }

    public void setGlobalRole(GlobalRole globalRole) {
        this.globalRole = globalRole;
    }

    public void setProjectRoleAssociations(Set<ProjectRoleAssociation> projectRoleAssociations) {
        this.projectRoleAssociations = projectRoleAssociations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authorisations)) {
            return false;
        }
        Authorisations other = (Authorisations)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GlobalRole this$globalRole = this.getGlobalRole();
        GlobalRole other$globalRole = other.getGlobalRole();
        if (this$globalRole == null ? other$globalRole != null : !((Object)this$globalRole).equals(other$globalRole)) {
            return false;
        }
        Set<ProjectRoleAssociation> this$projectRoleAssociations = this.getProjectRoleAssociations();
        Set<ProjectRoleAssociation> other$projectRoleAssociations = other.getProjectRoleAssociations();
        return !(this$projectRoleAssociations == null ? other$projectRoleAssociations != null : !((Object)this$projectRoleAssociations).equals(other$projectRoleAssociations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Authorisations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GlobalRole $globalRole = this.getGlobalRole();
        result = result * 59 + ($globalRole == null ? 43 : ((Object)$globalRole).hashCode());
        Set<ProjectRoleAssociation> $projectRoleAssociations = this.getProjectRoleAssociations();
        result = result * 59 + ($projectRoleAssociations == null ? 43 : ((Object)$projectRoleAssociations).hashCode());
        return result;
    }

    public String toString() {
        return "Authorisations(globalRole=" + this.getGlobalRole() + ", projectRoleAssociations=" + this.getProjectRoleAssociations() + ")";
    }

    private Authorisations(GlobalRole globalRole, Set<ProjectRoleAssociation> projectRoleAssociations) {
        this.globalRole = globalRole;
        this.projectRoleAssociations = projectRoleAssociations;
    }

    private GlobalRole getGlobalRole() {
        return this.globalRole;
    }

    private Set<ProjectRoleAssociation> getProjectRoleAssociations() {
        return this.projectRoleAssociations;
    }
}

