/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountUserDetails;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthenticatedAccount {
    private final Account account;
    private final UserDetails userDetails;

    public static AuthenticatedAccount of(Account account) {
        return new AuthenticatedAccount(account, new AccountUserDetails(account));
    }

    @ConstructorProperties(value={"account", "userDetails"})
    public AuthenticatedAccount(Account account, UserDetails userDetails) {
        this.account = account;
        this.userDetails = userDetails;
    }

    public Account getAccount() {
        return this.account;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatedAccount)) {
            return false;
        }
        AuthenticatedAccount other = (AuthenticatedAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        UserDetails this$userDetails = this.getUserDetails();
        UserDetails other$userDetails = other.getUserDetails();
        return !(this$userDetails == null ? other$userDetails != null : !this$userDetails.equals(other$userDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticatedAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        UserDetails $userDetails = this.getUserDetails();
        result = result * 59 + ($userDetails == null ? 43 : $userDetails.hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticatedAccount(account=" + this.getAccount() + ", userDetails=" + this.getUserDetails() + ")";
    }
}

