/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountGroupSelection;
import net.nemerosa.ontrack.model.security.AccountInput;
import net.nemerosa.ontrack.model.security.AuthenticatedAccount;
import net.nemerosa.ontrack.model.security.AuthenticationSourceProvider;
import net.nemerosa.ontrack.model.security.GlobalPermission;
import net.nemerosa.ontrack.model.security.GlobalRole;
import net.nemerosa.ontrack.model.security.PermissionInput;
import net.nemerosa.ontrack.model.security.PermissionTarget;
import net.nemerosa.ontrack.model.security.PermissionTargetType;
import net.nemerosa.ontrack.model.security.ProjectPermission;
import net.nemerosa.ontrack.model.security.ProjectRole;
import net.nemerosa.ontrack.model.security.ProjectRoleAssociation;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;

public interface AccountService {
    public Account withACL(AuthenticatedAccount var1);

    public List<Account> getAccounts();

    public Account create(AccountInput var1);

    public Account create(AccountInput var1, String var2);

    public Optional<Account> findUserByNameAndSource(String var1, AuthenticationSourceProvider var2);

    public Account getAccount(ID var1);

    public Account updateAccount(ID var1, AccountInput var2);

    public Ack deleteAccount(ID var1);

    public List<AccountGroup> getAccountGroups();

    public AccountGroup createGroup(NameDescription var1);

    public AccountGroup getAccountGroup(ID var1);

    public AccountGroup updateGroup(ID var1, NameDescription var2);

    public Ack deleteGroup(ID var1);

    public List<AccountGroupSelection> getAccountGroupsForSelection(ID var1);

    public Collection<PermissionTarget> searchPermissionTargets(String var1);

    public Ack saveGlobalPermission(PermissionTargetType var1, int var2, PermissionInput var3);

    public Collection<GlobalPermission> getGlobalPermissions();

    public Ack deleteGlobalPermission(PermissionTargetType var1, int var2);

    public Collection<ProjectPermission> getProjectPermissions(ID var1);

    public Ack saveProjectPermission(ID var1, PermissionTargetType var2, int var3, PermissionInput var4);

    public Ack deleteProjectPermission(ID var1, PermissionTargetType var2, int var3);

    public Collection<ProjectRoleAssociation> getProjectPermissionsForAccount(Account var1);

    public Optional<GlobalRole> getGlobalRoleForAccount(Account var1);

    public List<Account> getAccountsForGroup(AccountGroup var1);

    public Optional<GlobalRole> getGlobalRoleForAccountGroup(AccountGroup var1);

    public Collection<ProjectRoleAssociation> getProjectPermissionsForAccountGroup(AccountGroup var1);

    public Collection<AccountGroup> findAccountGroupsByGlobalRole(GlobalRole var1);

    public Collection<Account> findAccountsByGlobalRole(GlobalRole var1);

    public Collection<AccountGroup> findAccountGroupsByProjectRole(Project var1, ProjectRole var2);

    public Collection<Account> findAccountsByProjectRole(Project var1, ProjectRole var2);
}

