/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.beans.ConstructorProperties;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class AccountInput {
    @NotNull(message="The account name is required.")
    @Pattern(regexp="[a-zA-Z0-9]+", message="The account name must contain only letters and digits.")
    private final String name;
    @NotNull(message="The account full name is required.")
    @Size(min=1, max=100, message="The account full name must be between 1 and 100 long.")
    private final String fullName;
    @NotNull(message="The account email is required.")
    @Size(min=1, max=200, message="The account email must be between 1 and 200 long.")
    private final String email;
    private final String password;
    private final Collection<Integer> groups;

    @ConstructorProperties(value={"name", "fullName", "email", "password", "groups"})
    public AccountInput(String name, String fullName, String email, String password, Collection<Integer> groups) {
        this.name = name;
        this.fullName = fullName;
        this.email = email;
        this.password = password;
        this.groups = groups;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public Collection<Integer> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountInput)) {
            return false;
        }
        AccountInput other = (AccountInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Collection<Integer> this$groups = this.getGroups();
        Collection<Integer> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Collection<Integer> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public String toString() {
        return "AccountInput(name=" + this.getName() + ", fullName=" + this.getFullName() + ", email=" + this.getEmail() + ", password=" + this.getPassword() + ", groups=" + this.getGroups() + ")";
    }
}

