/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import net.nemerosa.ontrack.model.security.Authorisations;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.GlobalRole;
import net.nemerosa.ontrack.model.security.PermissionTarget;
import net.nemerosa.ontrack.model.security.PermissionTargetType;
import net.nemerosa.ontrack.model.security.ProjectFunction;
import net.nemerosa.ontrack.model.security.ProjectRoleAssociation;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;

public class AccountGroup
implements Entity,
Serializable {
    private final ID id;
    private final String name;
    private final String description;
    private Authorisations authorisations;
    private final boolean locked;

    public boolean isGranted(Class<? extends GlobalFunction> fn) {
        return this.authorisations.isGranted(fn);
    }

    public boolean isGranted(int projectId, Class<? extends ProjectFunction> fn) {
        return this.authorisations.isGranted(projectId, fn);
    }

    private void checkLock() {
        if (this.locked) {
            throw new IllegalStateException("Account is locked");
        }
    }

    public AccountGroup withGlobalRole(Optional<GlobalRole> globalRole) {
        this.checkLock();
        this.authorisations = this.authorisations.withGlobalRole(globalRole);
        return this;
    }

    public AccountGroup withProjectRoles(Collection<ProjectRoleAssociation> projectRoleAssociations) {
        this.checkLock();
        this.authorisations = this.authorisations.withProjectRoles(projectRoleAssociations);
        return this;
    }

    public AccountGroup withProjectRole(ProjectRoleAssociation projectRoleAssociation) {
        this.checkLock();
        this.authorisations = this.authorisations.withProjectRole(projectRoleAssociation);
        return this;
    }

    public AccountGroup lock() {
        return new AccountGroup(this.id, this.name, this.description, this.authorisations, true);
    }

    public static AccountGroup of(String name, String description) {
        return new AccountGroup(ID.NONE, name, description, Authorisations.none(), false);
    }

    public AccountGroup withId(ID id) {
        this.checkLock();
        return new AccountGroup(id, this.name, this.description, this.authorisations, this.locked);
    }

    public AccountGroup update(NameDescription input) {
        this.checkLock();
        return new AccountGroup(this.id, input.getName(), input.getDescription(), this.authorisations, this.locked);
    }

    public PermissionTarget asPermissionTarget() {
        return new PermissionTarget(PermissionTargetType.GROUP, this.id(), this.getName(), this.getDescription());
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setAuthorisations(Authorisations authorisations) {
        this.authorisations = authorisations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountGroup)) {
            return false;
        }
        AccountGroup other = (AccountGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Authorisations this$authorisations = this.getAuthorisations();
        Authorisations other$authorisations = other.getAuthorisations();
        if (this$authorisations == null ? other$authorisations != null : !((Object)this$authorisations).equals(other$authorisations)) {
            return false;
        }
        return this.isLocked() == other.isLocked();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Authorisations $authorisations = this.getAuthorisations();
        result = result * 59 + ($authorisations == null ? 43 : ((Object)$authorisations).hashCode());
        result = result * 59 + (this.isLocked() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AccountGroup(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", authorisations=" + this.getAuthorisations() + ", locked=" + this.isLocked() + ")";
    }

    @ConstructorProperties(value={"id", "name", "description", "authorisations", "locked"})
    protected AccountGroup(ID id, String name, String description, Authorisations authorisations, boolean locked) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.authorisations = authorisations;
        this.locked = locked;
    }

    private Authorisations getAuthorisations() {
        return this.authorisations;
    }

    private boolean isLocked() {
        return this.locked;
    }
}

