/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountInput;
import net.nemerosa.ontrack.model.security.AuthenticationSource;
import net.nemerosa.ontrack.model.security.Authorisations;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.GlobalRole;
import net.nemerosa.ontrack.model.security.PermissionTarget;
import net.nemerosa.ontrack.model.security.PermissionTargetType;
import net.nemerosa.ontrack.model.security.ProjectFunction;
import net.nemerosa.ontrack.model.security.ProjectRoleAssociation;
import net.nemerosa.ontrack.model.security.SecurityRole;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import org.apache.commons.lang3.StringUtils;

public class Account
implements Entity,
Serializable {
    private final ID id;
    private final String name;
    private final String fullName;
    private final String email;
    private final AuthenticationSource authenticationSource;
    private final SecurityRole role;
    private final List<AccountGroup> accountGroups;
    private Authorisations authorisations;
    private final boolean locked;

    public static Account of(String name, String fullName, String email, SecurityRole role, AuthenticationSource authenticationSource) {
        return new Account(ID.NONE, name, fullName, email, authenticationSource, role, new ArrayList<AccountGroup>(), Authorisations.none(), false);
    }

    public boolean isGranted(Class<? extends GlobalFunction> fn) {
        return SecurityRole.ADMINISTRATOR == this.role || this.accountGroups.stream().anyMatch(group -> group.isGranted(fn)) || this.authorisations.isGranted(fn);
    }

    public boolean isGranted(int projectId, Class<? extends ProjectFunction> fn) {
        return SecurityRole.ADMINISTRATOR == this.role || this.accountGroups.stream().anyMatch(group -> group.isGranted(projectId, fn)) || this.authorisations.isGranted(projectId, fn);
    }

    public Account withId(ID id) {
        this.checkLock();
        return new Account(id, this.name, this.fullName, this.email, this.authenticationSource, this.role, this.accountGroups, this.authorisations, this.locked);
    }

    public Account lock() {
        return new Account(this.id, this.name, this.fullName, this.email, this.authenticationSource, this.role, this.accountGroups, this.authorisations, true);
    }

    public Account update(AccountInput input) {
        return new Account(this.id, input.getName(), input.getFullName(), input.getEmail(), this.authenticationSource, this.role, this.accountGroups, this.authorisations, this.locked);
    }

    private void checkLock() {
        if (this.locked) {
            throw new IllegalStateException("Account is locked");
        }
    }

    public Account withGroup(AccountGroup accountGroup) {
        this.checkLock();
        this.accountGroups.add(accountGroup);
        return this;
    }

    public Account withGroups(Collection<AccountGroup> groups) {
        this.checkLock();
        this.accountGroups.addAll(groups);
        return this;
    }

    public Account withGlobalRole(Optional<GlobalRole> globalRole) {
        this.checkLock();
        this.authorisations = this.authorisations.withGlobalRole(globalRole);
        return this;
    }

    public Account withProjectRoles(Collection<ProjectRoleAssociation> projectRoleAssociations) {
        this.checkLock();
        this.authorisations = this.authorisations.withProjectRoles(projectRoleAssociations);
        return this;
    }

    public Account withProjectRole(ProjectRoleAssociation projectRoleAssociation) {
        this.checkLock();
        this.authorisations = this.authorisations.withProjectRole(projectRoleAssociation);
        return this;
    }

    public boolean isDefaultAdmin() {
        return StringUtils.equals((CharSequence)"admin", (CharSequence)this.name);
    }

    public PermissionTarget asPermissionTarget() {
        return new PermissionTarget(PermissionTargetType.ACCOUNT, this.id(), this.getName(), this.getFullName());
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public AuthenticationSource getAuthenticationSource() {
        return this.authenticationSource;
    }

    public SecurityRole getRole() {
        return this.role;
    }

    public List<AccountGroup> getAccountGroups() {
        return this.accountGroups;
    }

    public void setAuthorisations(Authorisations authorisations) {
        this.authorisations = authorisations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        AuthenticationSource this$authenticationSource = this.getAuthenticationSource();
        AuthenticationSource other$authenticationSource = other.getAuthenticationSource();
        if (this$authenticationSource == null ? other$authenticationSource != null : !((Object)this$authenticationSource).equals(other$authenticationSource)) {
            return false;
        }
        SecurityRole this$role = this.getRole();
        SecurityRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        List<AccountGroup> this$accountGroups = this.getAccountGroups();
        List<AccountGroup> other$accountGroups = other.getAccountGroups();
        if (this$accountGroups == null ? other$accountGroups != null : !((Object)this$accountGroups).equals(other$accountGroups)) {
            return false;
        }
        Authorisations this$authorisations = this.getAuthorisations();
        Authorisations other$authorisations = other.getAuthorisations();
        if (this$authorisations == null ? other$authorisations != null : !((Object)this$authorisations).equals(other$authorisations)) {
            return false;
        }
        return this.isLocked() == other.isLocked();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        AuthenticationSource $authenticationSource = this.getAuthenticationSource();
        result = result * 59 + ($authenticationSource == null ? 43 : ((Object)$authenticationSource).hashCode());
        SecurityRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        List<AccountGroup> $accountGroups = this.getAccountGroups();
        result = result * 59 + ($accountGroups == null ? 43 : ((Object)$accountGroups).hashCode());
        Authorisations $authorisations = this.getAuthorisations();
        result = result * 59 + ($authorisations == null ? 43 : ((Object)$authorisations).hashCode());
        result = result * 59 + (this.isLocked() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Account(id=" + this.getId() + ", name=" + this.getName() + ", fullName=" + this.getFullName() + ", email=" + this.getEmail() + ", authenticationSource=" + this.getAuthenticationSource() + ", role=" + (Object)((Object)this.getRole()) + ", accountGroups=" + this.getAccountGroups() + ", authorisations=" + this.getAuthorisations() + ", locked=" + this.isLocked() + ")";
    }

    @ConstructorProperties(value={"id", "name", "fullName", "email", "authenticationSource", "role", "accountGroups", "authorisations", "locked"})
    protected Account(ID id, String name, String fullName, String email, AuthenticationSource authenticationSource, SecurityRole role, List<AccountGroup> accountGroups, Authorisations authorisations, boolean locked) {
        this.id = id;
        this.name = name;
        this.fullName = fullName;
        this.email = email;
        this.authenticationSource = authenticationSource;
        this.role = role;
        this.accountGroups = accountGroups;
        this.authorisations = authorisations;
        this.locked = locked;
    }

    private Authorisations getAuthorisations() {
        return this.authorisations;
    }

    private boolean isLocked() {
        return this.locked;
    }
}

