/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.metrics;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.metrics.Metric;

public final class TaggedMetric<T extends Number>
extends Metric<T> {
    private final Map<String, String> tags;

    public TaggedMetric(String name, T value, Date timestamp, Map<String, String> tags) {
        super(name, value, timestamp);
        this.tags = tags;
    }

    public static <T extends Number> TaggedMetricBuilder<T> of(String name, T value) {
        return new TaggedMetricBuilder<T>(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaggedMetric)) {
            return false;
        }
        TaggedMetric other = (TaggedMetric)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaggedMetric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "TaggedMetric(super=" + super.toString() + ", tags=" + this.getTags() + ")";
    }

    public static class TaggedMetricBuilder<T extends Number> {
        private final String name;
        private final Date time;
        private final T value;
        private final Map<String, String> tags = new LinkedHashMap<String, String>();

        public TaggedMetricBuilder(String name, T value) {
            this.name = name;
            this.value = value;
            this.time = new Date();
        }

        public TaggedMetricBuilder<T> tag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public TaggedMetric<T> build() {
            return new TaggedMetric<T>(this.name, this.value, this.time, Collections.unmodifiableMap(this.tags));
        }

        public String getName() {
            return this.name;
        }

        public Date getTime() {
            return this.time;
        }

        public T getValue() {
            return this.value;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaggedMetricBuilder)) {
                return false;
            }
            TaggedMetricBuilder other = (TaggedMetricBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Date this$time = this.getTime();
            Date other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Map<String, String> this$tags = this.getTags();
            Map<String, String> other$tags = other.getTags();
            return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaggedMetricBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Date $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Map<String, String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            return result;
        }

        public String toString() {
            return "TaggedMetric.TaggedMetricBuilder(name=" + this.getName() + ", time=" + this.getTime() + ", value=" + this.getValue() + ", tags=" + this.getTags() + ")";
        }
    }
}

