/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.form;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.nemerosa.ontrack.model.form.DateTime;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.FormFieldNotFoundException;
import net.nemerosa.ontrack.model.form.Memo;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.form.Url;

public class Form {
    private final Map<String, Field> fields = new LinkedHashMap<String, Field>();

    public static Form nameAndDescription() {
        return Form.create().name().description();
    }

    public static Form create() {
        return new Form();
    }

    public Form name() {
        return this.with(Form.defaultNameField());
    }

    public Form password() {
        return this.with((Field)((Password)((Password)Password.of("password").label("Password")).length(40)).validation("Password is required."));
    }

    public Form description() {
        return this.with(((Memo)((Memo)((Memo)Memo.of("description").label("Description")).optional()).length(500)).rows(3));
    }

    public Form dateTime() {
        return this.with((Field)DateTime.of("dateTime").label("Date/time"));
    }

    public Form url() {
        return this.with(Url.of());
    }

    public Form with(Field field) {
        this.fields.put(field.getName(), field);
        return this;
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public Collection<? extends Field> getFields() {
        return this.fields.values();
    }

    public Form name(String value) {
        return this.fill("name", value);
    }

    public Form description(String value) {
        return this.fill("description", value);
    }

    public Form fill(String name, Object value) {
        Field field = this.fields.get(name);
        if (field == null) {
            throw new FormFieldNotFoundException(name);
        }
        field = field.value(value);
        this.fields.put(name, field);
        return this;
    }

    public Form fill(Map<String, ?> data) {
        data.forEach((name, value) -> {
            if (this.fields.containsKey(name)) {
                this.fill((String)name, value);
            }
        });
        return this;
    }

    public static Text defaultNameField() {
        return (Text)((Text)((Text)Text.of("name").label("Name")).length(40)).regex("[A-Za-z0-9_\\.\\-]+").validation("Name is required and must contain only alpha-numeric characters, underscores, points or dashes.");
    }

    public Form append(Form form) {
        this.fields.putAll(form.fields);
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Form)) {
            return false;
        }
        Form other = (Form)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<? extends Field> this$fields = this.getFields();
        Collection<? extends Field> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Form;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<? extends Field> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "Form(fields=" + this.getFields() + ")";
    }
}

