/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.form;

import com.fasterxml.jackson.annotation.JsonInclude;
import net.nemerosa.ontrack.model.form.Field;

public abstract class AbstractField<F extends AbstractField<F>>
implements Field {
    private final String type;
    private final String name;
    private String label;
    private boolean required = true;
    private boolean readOnly = false;
    private String validation;
    private String help = "";
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String visibleIf;
    private Object value;

    protected AbstractField(String type, String name) {
        this.type = type;
        this.name = name;
        this.label = name;
    }

    public F optional() {
        this.required = false;
        return (F)this;
    }

    public F readOnly() {
        this.readOnly = true;
        return (F)this;
    }

    public F visibleIf(String value) {
        this.visibleIf = value;
        return (F)this;
    }

    public F label(String label) {
        this.label = label;
        return (F)this;
    }

    public F validation(String value) {
        this.validation = value;
        return (F)this;
    }

    public F help(String value) {
        this.help = value;
        return (F)this;
    }

    public F value(Object value) {
        this.value = value;
        return (F)this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getValidation() {
        return this.validation;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    public String getVisibleIf() {
        return this.visibleIf;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setVisibleIf(String visibleIf) {
        this.visibleIf = visibleIf;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractField)) {
            return false;
        }
        AbstractField other = (AbstractField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        String this$validation = this.getValidation();
        String other$validation = other.getValidation();
        if (this$validation == null ? other$validation != null : !this$validation.equals(other$validation)) {
            return false;
        }
        String this$help = this.getHelp();
        String other$help = other.getHelp();
        if (this$help == null ? other$help != null : !this$help.equals(other$help)) {
            return false;
        }
        String this$visibleIf = this.getVisibleIf();
        String other$visibleIf = other.getVisibleIf();
        if (this$visibleIf == null ? other$visibleIf != null : !this$visibleIf.equals(other$visibleIf)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        String $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : $validation.hashCode());
        String $help = this.getHelp();
        result = result * 59 + ($help == null ? 43 : $help.hashCode());
        String $visibleIf = this.getVisibleIf();
        result = result * 59 + ($visibleIf == null ? 43 : $visibleIf.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractField(type=" + this.getType() + ", name=" + this.getName() + ", label=" + this.getLabel() + ", required=" + this.isRequired() + ", readOnly=" + this.isReadOnly() + ", validation=" + this.getValidation() + ", help=" + this.getHelp() + ", visibleIf=" + this.getVisibleIf() + ", value=" + this.getValue() + ")";
    }
}

