/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.extension;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;

public class ExtensionFeatureOptions {
    public static final ExtensionFeatureOptions DEFAULT = ExtensionFeatureOptions.builder().gui(false).dependencies(Collections.emptySet()).build();
    private final boolean gui;
    private final Set<String> dependencies;

    public ExtensionFeatureOptions withDependency(ExtensionFeature feature) {
        Set<String> existing = this.dependencies;
        HashSet<Object> newDependencies = existing == null ? new HashSet() : new HashSet<String>(existing);
        newDependencies.add(feature.getId());
        return this.withDependencies(newDependencies);
    }

    ExtensionFeatureOptions(boolean gui, Set<String> dependencies) {
        this.gui = gui;
        this.dependencies = dependencies;
    }

    public static ExtensionFeatureOptionsBuilder builder() {
        return new ExtensionFeatureOptionsBuilder();
    }

    public boolean isGui() {
        return this.gui;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtensionFeatureOptions)) {
            return false;
        }
        ExtensionFeatureOptions other = (ExtensionFeatureOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGui() != other.isGui()) {
            return false;
        }
        Set<String> this$dependencies = this.getDependencies();
        Set<String> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtensionFeatureOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGui() ? 79 : 97);
        Set<String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    public String toString() {
        return "ExtensionFeatureOptions(gui=" + this.isGui() + ", dependencies=" + this.getDependencies() + ")";
    }

    public ExtensionFeatureOptions withGui(boolean gui) {
        return this.gui == gui ? this : new ExtensionFeatureOptions(gui, this.dependencies);
    }

    public ExtensionFeatureOptions withDependencies(Set<String> dependencies) {
        return this.dependencies == dependencies ? this : new ExtensionFeatureOptions(this.gui, dependencies);
    }

    public static class ExtensionFeatureOptionsBuilder {
        private boolean gui;
        private Set<String> dependencies;

        ExtensionFeatureOptionsBuilder() {
        }

        public ExtensionFeatureOptionsBuilder gui(boolean gui) {
            this.gui = gui;
            return this;
        }

        public ExtensionFeatureOptionsBuilder dependencies(Set<String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public ExtensionFeatureOptions build() {
            return new ExtensionFeatureOptions(this.gui, this.dependencies);
        }

        public String toString() {
            return "ExtensionFeatureOptions.ExtensionFeatureOptionsBuilder(gui=" + this.gui + ", dependencies=" + this.dependencies + ")";
        }
    }
}

