/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.events;

import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nemerosa.ontrack.model.events.EventMissingEntityException;
import net.nemerosa.ontrack.model.events.EventMissingRefEntityException;
import net.nemerosa.ontrack.model.events.EventMissingValueException;
import net.nemerosa.ontrack.model.events.EventRenderer;
import net.nemerosa.ontrack.model.events.EventType;
import net.nemerosa.ontrack.model.events.PlainEventRenderer;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.support.NameValue;
import org.apache.commons.lang3.StringUtils;

public final class Event {
    private static final Pattern EXPRESSION = Pattern.compile("\\$\\{([:a-zA-Z_]+)\\}");
    private final EventType eventType;
    private final Signature signature;
    private final Map<ProjectEntityType, ProjectEntity> entities;
    private final ProjectEntityType ref;
    private final Map<String, NameValue> values;

    public int getIntValue(String name) {
        return Integer.parseInt(this.getValue(name), 10);
    }

    public String getValue(String name) {
        return this.getOptionalValue(name).orElseThrow(() -> new IllegalStateException(String.format("Missing '%s' in the event", name)));
    }

    public Optional<String> getOptionalValue(String name) {
        return Optional.of(this.values.get(name)).map(NameValue::getValue);
    }

    public <T extends ProjectEntity> T getEntity(ProjectEntityType entityType) {
        return (T)((ProjectEntity)this.getOptionalEntity(entityType).orElseThrow(() -> new IllegalStateException(String.format("Missing entity %s in the event", new Object[]{entityType}))));
    }

    public <T extends ProjectEntity> Optional<T> getOptionalEntity(ProjectEntityType entityType) {
        ProjectEntity entity = this.entities.get((Object)entityType);
        return Optional.of(entity);
    }

    public String renderText() {
        return this.render(PlainEventRenderer.INSTANCE);
    }

    public String render(EventRenderer eventRenderer) {
        Matcher m = EXPRESSION.matcher(this.eventType.getTemplate());
        StringBuffer output = new StringBuffer();
        while (m.find()) {
            String value = this.expandExpression(m.group(1), eventRenderer);
            m.appendReplacement(output, value);
        }
        m.appendTail(output);
        return output.toString();
    }

    private String expandExpression(String expression, EventRenderer eventRenderer) {
        if (StringUtils.startsWith((CharSequence)expression, (CharSequence)":")) {
            String valueKey = expression.substring(1);
            NameValue value = this.values.get(valueKey);
            if (value == null) {
                throw new EventMissingValueException(this.eventType.getTemplate(), valueKey);
            }
            return eventRenderer.render(valueKey, value, this);
        }
        if ("REF".equals(expression)) {
            if (this.ref == null) {
                throw new EventMissingRefEntityException(this.eventType.getTemplate());
            }
            ProjectEntity entity = this.entities.get((Object)this.ref);
            if (entity == null) {
                throw new EventMissingEntityException(this.eventType.getTemplate(), this.ref);
            }
            return eventRenderer.render(entity, this);
        }
        ProjectEntityType projectEntityType = ProjectEntityType.valueOf(expression);
        ProjectEntity projectEntity = this.entities.get((Object)projectEntityType);
        if (projectEntity == null) {
            throw new EventMissingEntityException(this.eventType.getTemplate(), projectEntityType);
        }
        return eventRenderer.render(projectEntity, this);
    }

    public static EventBuilder of(EventType eventType) {
        return new EventBuilder(eventType);
    }

    public Event withSignature(Signature signature) {
        return new Event(this.eventType, signature, this.entities, this.ref, this.values);
    }

    @ConstructorProperties(value={"eventType", "signature", "entities", "ref", "values"})
    public Event(EventType eventType, Signature signature, Map<ProjectEntityType, ProjectEntity> entities, ProjectEntityType ref, Map<String, NameValue> values) {
        this.eventType = eventType;
        this.signature = signature;
        this.entities = entities;
        this.ref = ref;
        this.values = values;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Map<ProjectEntityType, ProjectEntity> getEntities() {
        return this.entities;
    }

    public ProjectEntityType getRef() {
        return this.ref;
    }

    public Map<String, NameValue> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        EventType this$eventType = this.getEventType();
        EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        Map<ProjectEntityType, ProjectEntity> this$entities = this.getEntities();
        Map<ProjectEntityType, ProjectEntity> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        ProjectEntityType this$ref = this.getRef();
        ProjectEntityType other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !((Object)((Object)this$ref)).equals((Object)other$ref)) {
            return false;
        }
        Map<String, NameValue> this$values = this.getValues();
        Map<String, NameValue> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        Map<ProjectEntityType, ProjectEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        ProjectEntityType $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : ((Object)((Object)$ref)).hashCode());
        Map<String, NameValue> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "Event(eventType=" + this.getEventType() + ", signature=" + this.getSignature() + ", entities=" + this.getEntities() + ", ref=" + (Object)((Object)this.getRef()) + ", values=" + this.getValues() + ")";
    }

    public static class EventBuilder {
        private final EventType eventType;
        private Signature signature;
        private Map<ProjectEntityType, ProjectEntity> entities = new LinkedHashMap<ProjectEntityType, ProjectEntity>();
        private ProjectEntityType ref = null;
        private Map<String, NameValue> values = new LinkedHashMap<String, NameValue>();

        public EventBuilder(EventType eventType) {
            this.eventType = eventType;
        }

        public EventBuilder with(Signature signature) {
            this.signature = signature;
            return this;
        }

        public EventBuilder withNoSignature() {
            this.signature = null;
            return this;
        }

        public EventBuilder withBuild(Build build) {
            return this.withBranch(build.getBranch()).with(build).with(build.getSignature());
        }

        public EventBuilder withPromotionRun(PromotionRun promotionRun) {
            return this.withBuild(promotionRun.getBuild()).with(promotionRun.getPromotionLevel()).with(promotionRun.getSignature());
        }

        public EventBuilder withValidationRun(ValidationRun validationRun) {
            return this.withBuild(validationRun.getBuild()).with(validationRun.getValidationStamp()).with(validationRun).with(validationRun.getLastStatus().getSignature());
        }

        public EventBuilder withPromotionLevel(PromotionLevel promotionLevel) {
            return this.withBranch(promotionLevel.getBranch()).with(promotionLevel);
        }

        public EventBuilder withValidationStamp(ValidationStamp validationStamp) {
            return this.withBranch(validationStamp.getBranch()).with(validationStamp);
        }

        public EventBuilder withBranch(Branch branch) {
            return this.withProject(branch.getProject()).with(branch);
        }

        public EventBuilder withProject(Project project) {
            return this.with(project);
        }

        public EventBuilder withRef(ProjectEntity entity) {
            this.ref = entity.getProjectEntityType();
            return this.withProject(entity.getProject()).with(entity);
        }

        public EventBuilder with(ProjectEntity entity) {
            this.entities.put(entity.getProjectEntityType(), entity);
            return this;
        }

        public EventBuilder withValidationRunStatus(ValidationRunStatusID statusID) {
            return this.with("status", new NameValue(statusID.getId(), statusID.getName()));
        }

        public EventBuilder with(String name, NameValue value) {
            this.values.put(name, value);
            return this;
        }

        public EventBuilder with(String name, String value) {
            return this.with(name, new NameValue(name, value));
        }

        public Event get() {
            Event event = new Event(this.eventType, this.signature, this.entities, this.ref, this.values);
            event.renderText();
            return event;
        }
    }
}

