/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.buildfilter;

import java.beans.ConstructorProperties;

public class BuildFilterResult {
    private final boolean accept;
    private final boolean goingOn;

    public static BuildFilterResult stopNowIf(boolean condition) {
        return new BuildFilterResult(!condition, !condition);
    }

    public static BuildFilterResult stopNow() {
        return new BuildFilterResult(false, false);
    }

    public static BuildFilterResult ok() {
        return new BuildFilterResult(true, true);
    }

    public static BuildFilterResult notAccept() {
        return new BuildFilterResult(false, true);
    }

    public static BuildFilterResult accept() {
        return new BuildFilterResult(true, true);
    }

    public BuildFilterResult goingOn() {
        return new BuildFilterResult(this.accept, true);
    }

    public BuildFilterResult stop() {
        return new BuildFilterResult(this.accept, false);
    }

    public BuildFilterResult acceptIf(boolean condition) {
        return new BuildFilterResult(this.accept && condition, this.goingOn);
    }

    public BuildFilterResult goOnIf(boolean condition) {
        return new BuildFilterResult(this.accept, this.goingOn && condition);
    }

    public BuildFilterResult doAccept() {
        return new BuildFilterResult(true, this.goingOn);
    }

    public boolean isAccept() {
        return this.accept;
    }

    public boolean isGoingOn() {
        return this.goingOn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildFilterResult)) {
            return false;
        }
        BuildFilterResult other = (BuildFilterResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAccept() != other.isAccept()) {
            return false;
        }
        return this.isGoingOn() == other.isGoingOn();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildFilterResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAccept() ? 79 : 97);
        result = result * 59 + (this.isGoingOn() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BuildFilterResult(accept=" + this.isAccept() + ", goingOn=" + this.isGoingOn() + ")";
    }

    @ConstructorProperties(value={"accept", "goingOn"})
    protected BuildFilterResult(boolean accept, boolean goingOn) {
        this.accept = accept;
        this.goingOn = goingOn;
    }
}

