/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.json;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import java.beans.ConstructorProperties;

public class ConstructorPropertiesAnnotationIntrospector
extends NopAnnotationIntrospector {
    public boolean hasCreatorAnnotation(Annotated a) {
        ConstructorProperties props;
        JsonCreator ann = (JsonCreator)this._findAnnotation(a, JsonCreator.class);
        if (ann != null) {
            return ann.mode() != JsonCreator.Mode.DISABLED;
        }
        return a instanceof AnnotatedConstructor && (props = (ConstructorProperties)this._findAnnotation(a, ConstructorProperties.class)) != null;
    }

    public PropertyName findNameForSerialization(Annotated a) {
        JsonGetter jg = (JsonGetter)this._findAnnotation(a, JsonGetter.class);
        if (jg != null) {
            return PropertyName.construct((String)jg.value());
        }
        JsonProperty pann = (JsonProperty)this._findAnnotation(a, JsonProperty.class);
        if (pann != null) {
            return PropertyName.construct((String)pann.value());
        }
        PropertyName ctorName = this._findConstructorName(a);
        if (ctorName != null) {
            return ctorName;
        }
        if (this._hasAnnotation(a, JsonSerialize.class) || this._hasAnnotation(a, JsonView.class) || this._hasAnnotation(a, JsonRawValue.class)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        JsonSetter js = (JsonSetter)this._findAnnotation(a, JsonSetter.class);
        if (js != null) {
            return PropertyName.construct((String)js.value());
        }
        JsonProperty pann = (JsonProperty)this._findAnnotation(a, JsonProperty.class);
        if (pann != null) {
            return PropertyName.construct((String)pann.value());
        }
        PropertyName ctorName = this._findConstructorName(a);
        if (ctorName != null) {
            return ctorName;
        }
        if (this._hasAnnotation(a, JsonDeserialize.class) || this._hasAnnotation(a, JsonView.class) || this._hasAnnotation(a, JsonUnwrapped.class) || this._hasAnnotation(a, JsonBackReference.class) || this._hasAnnotation(a, JsonManagedReference.class)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    protected PropertyName _findConstructorName(Annotated a) {
        ConstructorProperties props;
        AnnotatedParameter p;
        AnnotatedWithParams ctor;
        if (a instanceof AnnotatedParameter && (ctor = (p = (AnnotatedParameter)a).getOwner()) != null && (props = (ConstructorProperties)this._findAnnotation((Annotated)ctor, ConstructorProperties.class)) != null) {
            String[] names = props.value();
            int ix = p.getIndex();
            if (ix < names.length) {
                return PropertyName.construct((String)names[ix]);
            }
        }
        return null;
    }
}

