/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.DurationSerializer;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import net.nemerosa.ontrack.json.JDKLocalDateDeserializer;
import net.nemerosa.ontrack.json.JDKLocalDateSerializer;
import net.nemerosa.ontrack.json.JDKLocalDateTimeDeserializer;
import net.nemerosa.ontrack.json.JDKLocalDateTimeSerializer;
import net.nemerosa.ontrack.json.JDKLocalTimeDeserializer;
import net.nemerosa.ontrack.json.JDKLocalTimeSerializer;
import net.nemerosa.ontrack.json.JDKYearMonthDeserializer;
import net.nemerosa.ontrack.json.JDKYearMonthSerializer;

public final class ObjectMapperFactory {
    public static final Version JSON_MODULE_VERSION = new Version(1, 0, 0, null, "net.nemerosa.ontrack", "ontrack-json");

    public static ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectMapperFactory.jdkTime(mapper);
        mapper.registerModule((Module)new KotlinModule());
        return mapper;
    }

    public static ObjectMapper create(Class<?> viewClass) {
        return new CustomObjectMapper(viewClass);
    }

    private static void jdkTime(ObjectMapper mapper) {
        SimpleModule jdkTimeModule = new SimpleModule("JDKTimeModule", JSON_MODULE_VERSION);
        jdkTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new JDKLocalDateTimeSerializer());
        jdkTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JDKLocalDateTimeDeserializer());
        jdkTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new JDKLocalTimeSerializer());
        jdkTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new JDKLocalTimeDeserializer());
        jdkTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new JDKLocalDateSerializer());
        jdkTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new JDKLocalDateDeserializer());
        jdkTimeModule.addSerializer(YearMonth.class, (JsonSerializer)new JDKYearMonthSerializer());
        jdkTimeModule.addDeserializer(YearMonth.class, (JsonDeserializer)new JDKYearMonthDeserializer());
        jdkTimeModule.addSerializer(Duration.class, (JsonSerializer)DurationSerializer.INSTANCE);
        jdkTimeModule.addDeserializer(Duration.class, (JsonDeserializer)DurationDeserializer.INSTANCE);
        mapper.registerModule((Module)jdkTimeModule);
    }

    private ObjectMapperFactory() {
    }

    private static class CustomObjectMapper
    extends ObjectMapper {
        public CustomObjectMapper(Class<?> viewClass) {
            this._serializationConfig = this._serializationConfig.withView(viewClass);
        }
    }
}

