/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.json.JsonArrayMergePriority;
import net.nemerosa.ontrack.json.JsonConflictResolution;
import net.nemerosa.ontrack.json.JsonMergePriority;
import net.nemerosa.ontrack.json.JsonMissingFieldException;
import net.nemerosa.ontrack.json.JsonParseException;
import net.nemerosa.ontrack.json.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u001a/\u0010\u0000\u001a\u00020\u00012\"\u0010\u0002\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003\"\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0015\u0010\u0006\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0007*\u0002H\u0007\u00a2\u0006\u0002\u0010\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0001\u001a\u0019\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000f\u001a.\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\u0010\b\u0000\u0010\u0011\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00110\u0012*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u0013\u001a\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0016\u001a\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0015*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u001a\u0012\u0010\u0019\u001a\u00020\r*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u001a,\u0010\u001a\u001a\u0002H\u0011\"\u0010\b\u0000\u0010\u0011\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00110\u0012*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u0013\u001a\u0012\u0010\u001b\u001a\u00020\u0015*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u001a\u0012\u0010\u001d\u001a\u00020\n*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u001a\u0014\u0010\u001e\u001a\u0004\u0018\u00010\n*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n\u001a\f\u0010\u001f\u001a\u00020\r*\u0004\u0018\u00010\u0001\u001a0\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'\u001a\u001a\u0010(\u001a\u00020\u0001*\u00020)2\u0006\u0010!\u001a\u00020)2\u0006\u0010$\u001a\u00020%\u001a*\u0010*\u001a\u00020\u0001*\u00020+2\u0006\u0010!\u001a\u00020+2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'\u001a\u001a\u0010,\u001a\u0002H\u0007\"\u0006\b\u0000\u0010\u0007\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010-\u001a\n\u0010.\u001a\u00020\u0001*\u00020\n\u001a'\u0010/\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u000200*\u00020\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u000702\u00a2\u0006\u0002\u00103\u001a\u001c\u00104\u001a\u0004\u0018\u0001H\u0007\"\u0006\b\u0000\u0010\u0007\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010-\u001a\u0019\u00105\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0007*\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0014\u00106\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u000307*\u00020\u0001\u00a8\u00068"}, d2={"jsonOf", "Lcom/fasterxml/jackson/databind/JsonNode;", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lcom/fasterxml/jackson/databind/JsonNode;", "asJson", "T", "(Ljava/lang/Object;)Lcom/fasterxml/jackson/databind/JsonNode;", "asJsonString", "", "format", "getBooleanField", "", "field", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Boolean;", "getEnum", "E", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Enum;", "getInt", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Integer;", "getIntField", "getJsonField", "getRequiredBooleanField", "getRequiredEnum", "getRequiredIntField", "getRequiredJsonField", "getRequiredTextField", "getTextField", "isNullOrNullNode", "merge", "node", "priority", "Lnet/nemerosa/ontrack/json/JsonMergePriority;", "arrays", "Lnet/nemerosa/ontrack/json/JsonArrayMergePriority;", "conflictResolution", "Lnet/nemerosa/ontrack/json/JsonConflictResolution;", "mergeArray", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "mergeObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "parse", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "parseAsJson", "parseInto", "", "type", "Lkotlin/reflect/KClass;", "(Lcom/fasterxml/jackson/databind/JsonNode;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "parseOrNull", "toJson", "toJsonMap", "", "ontrack-json"})
public final class KTJsonUtilsKt {
    @NotNull
    public static final JsonNode parseAsJson(@NotNull String $this$parseAsJson) {
        Intrinsics.checkNotNullParameter((Object)$this$parseAsJson, (String)"<this>");
        JsonNode jsonNode = JsonUtils.parseAsNode($this$parseAsJson);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"parseAsNode(this)");
        return jsonNode;
    }

    @NotNull
    public static final JsonNode jsonOf(Pair<?, ?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        JsonNode jsonNode = KTJsonUtilsKt.toJson(MapsKt.mapOf(Arrays.copyOf(pairs, pairs.length)));
        Intrinsics.checkNotNull((Object)jsonNode);
        return jsonNode;
    }

    @Nullable
    public static final <T> JsonNode toJson(@Nullable T $this$toJson) {
        return JsonUtils.format($this$toJson);
    }

    @NotNull
    public static final <T> JsonNode asJson(T $this$asJson) {
        JsonNode jsonNode;
        if ($this$asJson instanceof JsonNode) {
            jsonNode = (JsonNode)$this$asJson;
        } else {
            JsonNode jsonNode2 = JsonUtils.format($this$asJson);
            jsonNode = jsonNode2;
            Intrinsics.checkNotNull((Object)jsonNode2);
        }
        return jsonNode;
    }

    @NotNull
    public static final Map<String, ?> toJsonMap(@NotNull JsonNode $this$toJsonMap) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsonMap, (String)"<this>");
        Map<String, ?> map = JsonUtils.toMap(KTJsonUtilsKt.asJson($this$toJsonMap));
        Intrinsics.checkNotNullExpressionValue(map, (String)"toMap(asJson())");
        return map;
    }

    @NotNull
    public static final String asJsonString(@NotNull JsonNode $this$asJsonString) {
        Intrinsics.checkNotNullParameter((Object)$this$asJsonString, (String)"<this>");
        String string = JsonUtils.toJSONString($this$asJsonString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(this)");
        return string;
    }

    public static final /* synthetic */ <T> T parse(JsonNode $this$parse) {
        Intrinsics.checkNotNullParameter((Object)$this$parse, (String)"<this>");
        boolean $i$f$parse = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)JsonUtils.parse($this$parse, Object.class);
    }

    @NotNull
    public static final <T> T parseInto(@NotNull JsonNode $this$parseInto, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$parseInto, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Object v = JsonUtils.parse($this$parseInto, JvmClassMappingKt.getJavaClass(type));
        Intrinsics.checkNotNullExpressionValue(v, (String)"parse(this, type.java)");
        return (T)v;
    }

    @NotNull
    public static final String format(@NotNull JsonNode $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        String string = JsonUtils.toJSONString($this$format);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(this)");
        return string;
    }

    public static final /* synthetic */ <T> T parseOrNull(JsonNode $this$parseOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$parseOrNull, (String)"<this>");
        boolean $i$f$parseOrNull = false;
        try {
            JsonNode $this$parse$iv = $this$parseOrNull;
            boolean $i$f$parse = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
            object = JsonUtils.parse($this$parse$iv, Object.class);
        }
        catch (JsonParseException jsonParseException) {
            object = null;
        }
        return (T)object;
    }

    public static final /* synthetic */ <E extends Enum<E>> E getEnum(JsonNode $this$getEnum, String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getEnum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        boolean $i$f$getEnum = false;
        String text = $this$getEnum.path(field).asText();
        CharSequence charSequence = text;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        charSequence = text;
        Intrinsics.reifiedOperationMarker((int)5, (String)"E");
        return (E)Enum.valueOf(null, (String)charSequence);
    }

    @Deprecated(message="Use getIntField", replaceWith=@ReplaceWith(expression="getIntField", imports={}))
    @Nullable
    public static final Integer getInt(@NotNull JsonNode $this$getInt, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return KTJsonUtilsKt.getIntField($this$getInt, field);
    }

    @Nullable
    public static final JsonNode getJsonField(@NotNull JsonNode $this$getJsonField, @NotNull String field) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getJsonField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if ($this$getJsonField.has(field)) {
            JsonNode jsonNode = $this$getJsonField.get(field);
            if (jsonNode != null) {
                JsonNode jsonNode2;
                JsonNode it = jsonNode2 = jsonNode;
                boolean bl = false;
                object = !it.isNull() ? jsonNode2 : null;
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public static final JsonNode getRequiredJsonField(@NotNull JsonNode $this$getRequiredJsonField, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getRequiredJsonField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        JsonNode jsonNode = KTJsonUtilsKt.getJsonField($this$getRequiredJsonField, field);
        if (jsonNode == null) {
            throw new JsonMissingFieldException(field);
        }
        return jsonNode;
    }

    @Nullable
    public static final Integer getIntField(@NotNull JsonNode $this$getIntField, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getIntField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return $this$getIntField.has(field) ? Integer.valueOf($this$getIntField.get(field).asInt()) : (Integer)null;
    }

    public static final /* synthetic */ <E extends Enum<E>> E getRequiredEnum(JsonNode $this$getRequiredEnum, String field) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)$this$getRequiredEnum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        boolean $i$f$getRequiredEnum = false;
        JsonNode $this$getEnum$iv = $this$getRequiredEnum;
        boolean $i$f$getEnum = false;
        String text$iv = $this$getEnum$iv.path(field).asText();
        CharSequence charSequence = text$iv;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            v0 = null;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)text$iv, (String)"text");
            charSequence = text$iv;
            Intrinsics.reifiedOperationMarker((int)5, (String)"E");
            v0 = Enum.valueOf(null, (String)charSequence);
        }
        if (v0 == null) {
            throw new JsonMissingFieldException(field);
        }
        return (E)((Enum)v0);
    }

    public static final boolean isNullOrNullNode(@Nullable JsonNode $this$isNullOrNullNode) {
        return $this$isNullOrNullNode == null || $this$isNullOrNullNode.isNull();
    }

    @Nullable
    public static final String getTextField(@NotNull JsonNode $this$getTextField, @NotNull String field) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getTextField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if ($this$getTextField.has(field)) {
            JsonNode jsonNode;
            JsonNode it = jsonNode = $this$getTextField.get(field);
            boolean bl = false;
            Object object = !it.isNull() ? jsonNode : null;
            string = object != null ? object.asText() : null;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String getRequiredTextField(@NotNull JsonNode $this$getRequiredTextField, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getRequiredTextField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string = KTJsonUtilsKt.getTextField($this$getRequiredTextField, field);
        if (string == null) {
            throw new JsonParseException("Missing field " + field);
        }
        return string;
    }

    @Nullable
    public static final Boolean getBooleanField(@NotNull JsonNode $this$getBooleanField, @NotNull String field) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$getBooleanField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if ($this$getBooleanField.has(field)) {
            JsonNode jsonNode;
            JsonNode it = jsonNode = $this$getBooleanField.get(field);
            boolean bl2 = false;
            Object object = !it.isNull() ? jsonNode : null;
            bl = object != null ? Boolean.valueOf(object.asBoolean()) : null;
        } else {
            bl = null;
        }
        return bl;
    }

    public static final boolean getRequiredBooleanField(@NotNull JsonNode $this$getRequiredBooleanField, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getRequiredBooleanField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Boolean bl = KTJsonUtilsKt.getBooleanField($this$getRequiredBooleanField, field);
        if (bl == null) {
            throw new JsonParseException("Missing field " + field);
        }
        return bl;
    }

    public static final int getRequiredIntField(@NotNull JsonNode $this$getRequiredIntField, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getRequiredIntField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Integer n = KTJsonUtilsKt.getIntField($this$getRequiredIntField, field);
        if (n == null) {
            throw new JsonParseException("Missing field " + field);
        }
        return n;
    }

    @NotNull
    public static final JsonNode merge(@NotNull JsonNode $this$merge, @NotNull JsonNode node, @NotNull JsonMergePriority priority, @NotNull JsonArrayMergePriority arrays, @NotNull JsonConflictResolution conflictResolution) {
        JsonNode jsonNode;
        block15: {
            block13: {
                block16: {
                    JsonNode jsonNode2;
                    block14: {
                        Intrinsics.checkNotNullParameter((Object)$this$merge, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
                        Intrinsics.checkNotNullParameter((Object)((Object)arrays), (String)"arrays");
                        Intrinsics.checkNotNullParameter((Object)((Object)conflictResolution), (String)"conflictResolution");
                        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(node.getClass()), (Object)Reflection.getOrCreateKotlinClass($this$merge.getClass()))) break block13;
                        jsonNode2 = $this$merge;
                        if (!(jsonNode2 instanceof ObjectNode)) break block14;
                        jsonNode = KTJsonUtilsKt.mergeObject((ObjectNode)$this$merge, (ObjectNode)node, priority, arrays, conflictResolution);
                        break block15;
                    }
                    if (!(jsonNode2 instanceof ArrayNode)) break block16;
                    jsonNode = KTJsonUtilsKt.mergeArray((ArrayNode)$this$merge, (ArrayNode)node, arrays);
                    break block15;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[priority.ordinal()]) {
                    case 1: {
                        jsonNode = $this$merge;
                        break block15;
                    }
                    case 2: {
                        jsonNode = node;
                        break block15;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (KTJsonUtilsKt.isNullOrNullNode(node)) {
                jsonNode = $this$merge;
            } else if (KTJsonUtilsKt.isNullOrNullNode($this$merge)) {
                jsonNode = node;
            } else {
                switch (WhenMappings.$EnumSwitchMapping$1[conflictResolution.ordinal()]) {
                    case 1: {
                        throw new IllegalStateException("Cannot merge JSON because of type conflict.".toString());
                    }
                    case 2: {
                        jsonNode = $this$merge;
                        break;
                    }
                    case 3: {
                        jsonNode = node;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        return jsonNode;
    }

    public static /* synthetic */ JsonNode merge$default(JsonNode jsonNode, JsonNode jsonNode2, JsonMergePriority jsonMergePriority, JsonArrayMergePriority jsonArrayMergePriority, JsonConflictResolution jsonConflictResolution, int n, Object object) {
        if ((n & 2) != 0) {
            jsonMergePriority = JsonMergePriority.RIGHT;
        }
        if ((n & 4) != 0) {
            jsonArrayMergePriority = JsonArrayMergePriority.APPEND;
        }
        if ((n & 8) != 0) {
            jsonConflictResolution = JsonConflictResolution.ABORT;
        }
        return KTJsonUtilsKt.merge(jsonNode, jsonNode2, jsonMergePriority, jsonArrayMergePriority, jsonConflictResolution);
    }

    @NotNull
    public static final JsonNode mergeArray(@NotNull ArrayNode $this$mergeArray, @NotNull ArrayNode node, @NotNull JsonArrayMergePriority arrays) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)$this$mergeArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)arrays), (String)"arrays");
        switch (WhenMappings.$EnumSwitchMapping$2[arrays.ordinal()]) {
            case 1: {
                jsonNode = (JsonNode)$this$mergeArray;
                break;
            }
            case 2: {
                jsonNode = (JsonNode)node;
                break;
            }
            case 3: {
                ArrayNode target = $this$mergeArray.arrayNode();
                target.addAll($this$mergeArray);
                target.addAll(node);
                ArrayNode arrayNode = target;
                Intrinsics.checkNotNullExpressionValue((Object)arrayNode, (String)"{\n        val target = a\u2026ode)\n        target\n    }");
                jsonNode = (JsonNode)arrayNode;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsonNode;
    }

    @NotNull
    public static final JsonNode mergeObject(@NotNull ObjectNode $this$mergeObject, @NotNull ObjectNode node, @NotNull JsonMergePriority priority, @NotNull JsonArrayMergePriority arrays, @NotNull JsonConflictResolution conflictResolution) {
        String it;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)$this$mergeObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)((Object)arrays), (String)"arrays");
        Intrinsics.checkNotNullParameter((Object)((Object)conflictResolution), (String)"conflictResolution");
        Set names = new LinkedHashSet();
        Iterator iterator = $this$mergeObject.fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"this.fieldNames()");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
            ((Collection)names).add(it);
        }
        Iterator iterator3 = node.fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"node.fieldNames()");
        $this$forEach$iv = iterator3;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
            ((Collection)names).add(it);
        }
        ObjectNode target = $this$mergeObject.objectNode();
        Iterable $this$forEach$iv2 = names;
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            JsonNode value;
            JsonNode jsonNode;
            String name = (String)element$iv2;
            boolean bl = false;
            if ($this$mergeObject.has(name) && node.has(name)) {
                JsonNode jsonNode2 = $this$mergeObject.get(name);
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"this.get(name)");
                JsonNode jsonNode3 = node.get(name);
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode3, (String)"node.get(name)");
                jsonNode = KTJsonUtilsKt.merge(jsonNode2, jsonNode3, priority, arrays, conflictResolution);
            } else {
                jsonNode = $this$mergeObject.has(name) ? $this$mergeObject.get(name) : (node.has(name) ? node.get(name) : (JsonNode)null);
            }
            if ((value = jsonNode) == null) continue;
            target.set(name, value);
        }
        Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
        return (JsonNode)target;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[JsonMergePriority.values().length];
            nArray[JsonMergePriority.LEFT.ordinal()] = 1;
            nArray[JsonMergePriority.RIGHT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JsonConflictResolution.values().length];
            nArray[JsonConflictResolution.ABORT.ordinal()] = 1;
            nArray[JsonConflictResolution.LEFT.ordinal()] = 2;
            nArray[JsonConflictResolution.RIGHT.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[JsonArrayMergePriority.values().length];
            nArray[JsonArrayMergePriority.LEFT.ordinal()] = 1;
            nArray[JsonArrayMergePriority.RIGHT.ordinal()] = 2;
            nArray[JsonArrayMergePriority.APPEND.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

