/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.nemerosa.ontrack.json.JsonBuilder;

public class ObjectBuilder
implements JsonBuilder<ObjectNode> {
    private final JsonNodeFactory factory;
    private final ObjectNode thisNode;

    public ObjectBuilder(JsonNodeFactory factory) {
        this.factory = factory;
        this.thisNode = factory.objectNode();
    }

    public ObjectBuilder withNull(String field) {
        return this.with(field, (JsonNode)this.factory.nullNode());
    }

    public ObjectBuilder with(String field, int value) {
        return this.with(field, (JsonNode)this.factory.numberNode(value));
    }

    public ObjectBuilder with(String field, boolean value) {
        return this.with(field, (JsonNode)this.factory.booleanNode(value));
    }

    public ObjectBuilder with(String field, JsonNode node) {
        this.thisNode.set(field, node);
        return this;
    }

    public ObjectBuilder with(String field, String value) {
        return this.with(field, (JsonNode)this.factory.textNode(value));
    }

    @Override
    public ObjectNode end() {
        return this.thisNode;
    }
}

