/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.json.JsonMissingFieldException;
import net.nemerosa.ontrack.json.JsonParseException;
import net.nemerosa.ontrack.json.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a/\u0010\u0000\u001a\u00020\u00012\"\u0010\u0002\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003\"\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0015\u0010\u0006\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0007*\u0002H\u0007\u00a2\u0006\u0002\u0010\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0001\u001a\u0012\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\n0\n*\u00020\u0001\u001a.\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0010\b\u0000\u0010\u000e\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u0011\u001a\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014\u001a,\u0010\u0015\u001a\u0002H\u000e\"\u0010\b\u0000\u0010\u000e\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u0011\u001a\f\u0010\u0016\u001a\u00020\u0017*\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0018\u001a\u0002H\u0007\"\u0006\b\u0000\u0010\u0007\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0019\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\n\u001a\u001c\u0010\u001b\u001a\u0004\u0018\u0001H\u0007\"\u0006\b\u0000\u0010\u0007\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0019\u001a\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0007*\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u001d"}, d2={"jsonOf", "Lcom/fasterxml/jackson/databind/JsonNode;", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lcom/fasterxml/jackson/databind/JsonNode;", "asJson", "T", "(Ljava/lang/Object;)Lcom/fasterxml/jackson/databind/JsonNode;", "asJsonString", "", "format", "kotlin.jvm.PlatformType", "getEnum", "E", "", "field", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Enum;", "getInt", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Integer;", "getRequiredEnum", "isNullOrNullNode", "", "parse", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "parseAsJson", "parseOrNull", "toJson", "ontrack-json"})
public final class KTJsonUtilsKt {
    @NotNull
    public static final JsonNode parseAsJson(@NotNull String $this$parseAsJson) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parseAsJson, (String)"$this$parseAsJson");
        JsonNode jsonNode = JsonUtils.parseAsNode($this$parseAsJson);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"JsonUtils.parseAsNode(this)");
        return jsonNode;
    }

    @NotNull
    public static final JsonNode jsonOf(Pair<?, ?> ... pairs) {
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        JsonNode jsonNode = KTJsonUtilsKt.toJson(MapsKt.mapOf(Arrays.copyOf(pairs, pairs.length)));
        if (jsonNode == null) {
            Intrinsics.throwNpe();
        }
        return jsonNode;
    }

    @Nullable
    public static final <T> JsonNode toJson(@Nullable T $this$toJson) {
        return JsonUtils.format($this$toJson);
    }

    @NotNull
    public static final <T> JsonNode asJson(T $this$asJson) {
        JsonNode jsonNode = JsonUtils.format($this$asJson);
        if (jsonNode == null) {
            Intrinsics.throwNpe();
        }
        return jsonNode;
    }

    @NotNull
    public static final String asJsonString(@NotNull JsonNode $this$asJsonString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asJsonString, (String)"$this$asJsonString");
        String string = JsonUtils.toJSONString($this$asJsonString);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JsonUtils.toJSONString(this)");
        return string;
    }

    public static final /* synthetic */ <T> T parse(@NotNull JsonNode $this$parse) {
        int $i$f$parse = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$parse, (String)"$this$parse");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)JsonUtils.parse($this$parse, Object.class);
    }

    public static final String format(@NotNull JsonNode $this$format) {
        Intrinsics.checkParameterIsNotNull((Object)$this$format, (String)"$this$format");
        return JsonUtils.toJSONString($this$format);
    }

    @Nullable
    public static final /* synthetic */ <T> T parseOrNull(@NotNull JsonNode $this$parseOrNull) {
        Object object;
        int $i$f$parseOrNull = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$parseOrNull, (String)"$this$parseOrNull");
        try {
            JsonNode $this$parse$iv = $this$parseOrNull;
            boolean $i$f$parse = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
            object = JsonUtils.parse($this$parse$iv, Object.class);
        }
        catch (JsonParseException _) {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public static final /* synthetic */ <E extends Enum<E>> E getEnum(@NotNull JsonNode $this$getEnum, @NotNull String field) {
        int $i$f$getEnum = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$getEnum, (String)"$this$getEnum");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        String text = $this$getEnum.path(field).asText();
        CharSequence charSequence = text;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)5, (String)"E");
        return (E)Enum.valueOf(null, text);
    }

    @Nullable
    public static final Integer getInt(@NotNull JsonNode $this$getInt, @NotNull String field) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getInt, (String)"$this$getInt");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return $this$getInt.has(field) ? Integer.valueOf($this$getInt.get(field).asInt()) : null;
    }

    @NotNull
    public static final /* synthetic */ <E extends Enum<E>> E getRequiredEnum(@NotNull JsonNode $this$getRequiredEnum, @NotNull String field) {
        E e;
        int $i$f$getRequiredEnum = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$getRequiredEnum, (String)"$this$getRequiredEnum");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        JsonNode $this$getEnum$iv = $this$getRequiredEnum;
        boolean $i$f$getEnum = false;
        String text$iv = $this$getEnum$iv.path(field).asText();
        CharSequence charSequence = text$iv;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            e = null;
        } else {
            Intrinsics.reifiedOperationMarker((int)5, (String)"E");
            e = (E)Enum.valueOf(null, text$iv);
        }
        if (e == null) {
            throw (Throwable)new JsonMissingFieldException(field);
        }
        return e;
    }

    public static final boolean isNullOrNullNode(@Nullable JsonNode $this$isNullOrNullNode) {
        return $this$isNullOrNullNode == null || $this$isNullOrNullNode.isNull();
    }
}

