/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.nemerosa.ontrack.json.ArrayBuilder;
import net.nemerosa.ontrack.json.JDKLocalDateDeserializer;
import net.nemerosa.ontrack.json.JsonMissingFieldException;
import net.nemerosa.ontrack.json.JsonParseException;
import net.nemerosa.ontrack.json.ObjectBuilder;
import net.nemerosa.ontrack.json.ObjectMapperFactory;

public final class JsonUtils {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;
    private static final ObjectMapper mapper = ObjectMapperFactory.create();

    private JsonUtils() {
    }

    public static <V> V parse(JsonNode node, Class<V> type) {
        try {
            return (V)mapper.treeToValue((TreeNode)node, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException((Exception)((Object)e));
        }
    }

    public static JsonNode parseAsNode(String text) {
        try {
            return mapper.readTree(text);
        }
        catch (IOException e) {
            throw new JsonParseException(e);
        }
    }

    public static JsonNode format(Object value) {
        return mapper.valueToTree(value);
    }

    public static String toJSONString(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException((Exception)((Object)e));
        }
    }

    public static ObjectBuilder object() {
        return new ObjectBuilder(factory);
    }

    public static ArrayBuilder array() {
        return new ArrayBuilder(factory);
    }

    public static JsonNode stringArray(Iterable<String> values) {
        ArrayBuilder builder = JsonUtils.array();
        for (String value : values) {
            builder.with(JsonUtils.text(value));
        }
        return builder.end();
    }

    public static JsonNode intArray(int ... values) {
        ArrayBuilder builder = JsonUtils.array();
        for (int value : values) {
            builder.with(JsonUtils.number(value));
        }
        return builder.end();
    }

    public static JsonNode stringArray(String ... values) {
        return JsonUtils.stringArray(Arrays.asList(values));
    }

    public static Map<String, ?> toMap(JsonNode node) throws IOException {
        if (node.isObject()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode fieldNode = node.get(fieldName);
                map.put(fieldName, JsonUtils.toObject(fieldNode));
            }
            return map;
        }
        throw new IllegalArgumentException("Can only transform a JSON object into a map");
    }

    public static Object toObject(JsonNode node) throws IOException {
        JsonNodeType type = node.getNodeType();
        switch (type) {
            case ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (JsonNode child : node) {
                    list.add(JsonUtils.toObject(child));
                }
                return list;
            }
            case BINARY: {
                return node.binaryValue();
            }
            case BOOLEAN: {
                return node.booleanValue();
            }
            case NULL: {
                return null;
            }
            case NUMBER: {
                return node.numberValue();
            }
            case OBJECT: 
            case POJO: {
                return JsonUtils.toMap(node);
            }
        }
        return node.textValue();
    }

    public static JsonNode text(String text) {
        return factory.textNode(text);
    }

    public static JsonNode number(int value) {
        return factory.numberNode(value);
    }

    public static JsonNode mapToJson(Map<String, String> parameters) {
        ObjectBuilder builder = JsonUtils.object();
        if (parameters != null) {
            parameters.forEach(builder::with);
        }
        return builder.end();
    }

    public static JsonNode fromMap(Map<String, ?> map) {
        return ObjectMapperFactory.create().valueToTree(map);
    }

    public static String get(JsonNode data, String field) {
        return JsonUtils.get(data, field, true, null);
    }

    public static String get(JsonNode data, String field, String defaultValue) {
        return JsonUtils.get(data, field, false, defaultValue);
    }

    public static String get(JsonNode data, String field, boolean required, String defaultValue) {
        if (data.has(field)) {
            return data.path(field).textValue();
        }
        if (required) {
            throw new JsonMissingFieldException(field);
        }
        return defaultValue;
    }

    public static int getInt(JsonNode data, String field) {
        return JsonUtils.getInt(data, field, true, 0);
    }

    public static int getInt(JsonNode data, String field, int defaultValue) {
        return JsonUtils.getInt(data, field, false, defaultValue);
    }

    public static int getInt(JsonNode data, String field, boolean required, int defaultValue) {
        if (data.has(field)) {
            return data.path(field).asInt();
        }
        if (required) {
            throw new JsonMissingFieldException(field);
        }
        return defaultValue;
    }

    public static boolean getBoolean(JsonNode data, String field) {
        return JsonUtils.getBoolean(data, field, true, false);
    }

    public static boolean getBoolean(JsonNode data, String field, boolean defaultValue) {
        return JsonUtils.getBoolean(data, field, false, defaultValue);
    }

    public static boolean getBoolean(JsonNode data, String field, boolean required, boolean defaultValue) {
        if (data.has(field)) {
            return data.path(field).asBoolean();
        }
        if (required) {
            throw new JsonMissingFieldException(field);
        }
        return defaultValue;
    }

    public static LocalDate getDate(JsonNode data, String field, LocalDate defaultValue) {
        if (data.has(field) && !data.get(field).isNull()) {
            return JDKLocalDateDeserializer.parse(data.path(field).asText());
        }
        return defaultValue;
    }

    public static List<String> getStringList(JsonNode data, String field) {
        if (data.has(field)) {
            ArrayList<String> list = new ArrayList<String>();
            data.get(field).forEach(node -> list.add(node.asText()));
            return list;
        }
        return null;
    }

    public static String pretty(JsonNode node) throws JsonProcessingException {
        return ObjectMapperFactory.create().writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
    }
}

