/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.json.JsonMissingFieldException;
import net.nemerosa.ontrack.json.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a/\u0010\u0000\u001a\u00020\u00012\"\u0010\u0002\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003\"\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0015\u0010\u0006\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0007*\u0002H\u0007\u00a2\u0006\u0002\u0010\b\u001a.\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0010\b\u0000\u0010\n\u0018\u0001*\b\u0012\u0004\u0012\u0002H\n0\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0086\b\u00a2\u0006\u0002\u0010\u000e\u001a\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011\u001a,\u0010\u0012\u001a\u0002H\n\"\u0010\b\u0000\u0010\n\u0018\u0001*\b\u0012\u0004\u0012\u0002H\n0\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0086\b\u00a2\u0006\u0002\u0010\u000e\u001a\u001a\u0010\u0013\u001a\u0002H\u0007\"\u0006\b\u0000\u0010\u0007\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0014\u001a\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0007*\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u0016"}, d2={"jsonOf", "Lcom/fasterxml/jackson/databind/JsonNode;", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lcom/fasterxml/jackson/databind/JsonNode;", "asJson", "T", "(Ljava/lang/Object;)Lcom/fasterxml/jackson/databind/JsonNode;", "getEnum", "E", "", "field", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Enum;", "getInt", "", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)Ljava/lang/Integer;", "getRequiredEnum", "parse", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "toJson", "ontrack-json"})
public final class KTJsonUtilsKt {
    @NotNull
    public static final JsonNode jsonOf(Pair<?, ?> ... pairs) {
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        JsonNode jsonNode = KTJsonUtilsKt.toJson(MapsKt.mapOf(Arrays.copyOf(pairs, pairs.length)));
        if (jsonNode == null) {
            Intrinsics.throwNpe();
        }
        return jsonNode;
    }

    @Nullable
    public static final <T> JsonNode toJson(@Nullable T $receiver) {
        return JsonUtils.format($receiver);
    }

    @NotNull
    public static final <T> JsonNode asJson(T $receiver) {
        JsonNode jsonNode = JsonUtils.format($receiver);
        if (jsonNode == null) {
            Intrinsics.throwNpe();
        }
        return jsonNode;
    }

    private static final <T> T parse(@NotNull JsonNode $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)JsonUtils.parse($receiver, Object.class);
    }

    private static final <E extends Enum<E>> E getEnum(@NotNull JsonNode $receiver, String field) {
        String text = $receiver.path(field).asText();
        CharSequence charSequence = text;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)5, (String)"E");
        return (E)Enum.valueOf(null, text);
    }

    @Nullable
    public static final Integer getInt(@NotNull JsonNode $receiver, @NotNull String field) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        return $receiver.has(field) ? Integer.valueOf($receiver.get(field).asInt()) : null;
    }

    private static final <E extends Enum<E>> E getRequiredEnum(@NotNull JsonNode $receiver, String field) {
        E e;
        JsonNode $receiver$iv = $receiver;
        String text$iv = $receiver$iv.path(field).asText();
        CharSequence charSequence = text$iv;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            e = null;
        } else {
            Intrinsics.reifiedOperationMarker((int)5, (String)"E");
            e = (E)Enum.valueOf(null, text$iv);
        }
        if (e == null) {
            throw (Throwable)new JsonMissingFieldException(field);
        }
        return e;
    }
}

