/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.it;

import java.io.IOException;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsDropwizardAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@Profile(value={"unitTest"})
@EnableTransactionManagement
@Import(value={MetricRepositoryAutoConfiguration.class, MetricsDropwizardAutoConfiguration.class, HealthIndicatorAutoConfiguration.class})
public class ITConfig {
    private final Logger logger = LoggerFactory.getLogger(ITConfig.class);

    @Bean
    public javax.sql.DataSource dataSource() throws IOException {
        String dbURL = "jdbc:h2:mem:ontrack;MODE=MYSQL;DB_CLOSE_ON_EXIT=FALSE;DEFRAG_ALWAYS=TRUE";
        this.logger.info("Using database at {}", (Object)dbURL);
        DataSource pool = new DataSource();
        pool.setDriverClassName("org.h2.Driver");
        pool.setUrl(dbURL);
        pool.setUsername("sa");
        pool.setPassword("");
        pool.setDefaultAutoCommit(Boolean.valueOf(false));
        pool.setInitialSize(1);
        pool.setMaxActive(2);
        return pool;
    }

    @Bean
    public PlatformTransactionManager transactionManager() throws IOException {
        return new DataSourceTransactionManager(this.dataSource());
    }

    @Bean
    public ConverterRegistry converterRegistry() {
        return new DefaultConversionService();
    }
}

