/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.it;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.it.AbstractITTestSupport;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountGroupManagement;
import net.nemerosa.ontrack.model.security.AccountInput;
import net.nemerosa.ontrack.model.security.AccountManagement;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.security.AuthenticatedAccount;
import net.nemerosa.ontrack.model.security.AuthenticationSource;
import net.nemerosa.ontrack.model.security.BranchCreate;
import net.nemerosa.ontrack.model.security.BuildCreate;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.GlobalRole;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.PermissionInput;
import net.nemerosa.ontrack.model.security.PermissionTargetType;
import net.nemerosa.ontrack.model.security.ProjectAuthorisationMgt;
import net.nemerosa.ontrack.model.security.ProjectCreation;
import net.nemerosa.ontrack.model.security.ProjectEdit;
import net.nemerosa.ontrack.model.security.ProjectFunction;
import net.nemerosa.ontrack.model.security.ProjectRole;
import net.nemerosa.ontrack.model.security.ProjectRoleAssociation;
import net.nemerosa.ontrack.model.security.ProjectView;
import net.nemerosa.ontrack.model.security.PromotionLevelCreate;
import net.nemerosa.ontrack.model.security.PromotionRunCreate;
import net.nemerosa.ontrack.model.security.SecurityRole;
import net.nemerosa.ontrack.model.security.ValidationRunCreate;
import net.nemerosa.ontrack.model.security.ValidationStampCreate;
import net.nemerosa.ontrack.model.settings.SecuritySettings;
import net.nemerosa.ontrack.model.settings.SettingsManagerService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.PropertyType;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.test.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public abstract class AbstractServiceTestSupport
extends AbstractITTestSupport {
    @Autowired
    protected AccountService accountService;
    @Autowired
    protected StructureService structureService;
    @Autowired
    protected PropertyService propertyService;
    @Autowired
    private SettingsManagerService settingsManagerService;

    protected AccountGroup doCreateAccountGroup() throws Exception {
        return ((UserCall)this.asUser().with(AccountGroupManagement.class)).call(() -> {
            String name = TestUtils.uid((String)"G");
            return this.accountService.createGroup(NameDescription.nd((String)name, (String)""));
        });
    }

    protected Account doCreateAccount() throws Exception {
        return this.doCreateAccount(Collections.emptyList());
    }

    protected Account doCreateAccount(AccountGroup accountGroup) throws Exception {
        return this.doCreateAccount(Collections.singletonList(accountGroup));
    }

    protected Account doCreateAccount(List<AccountGroup> accountGroups) throws Exception {
        return ((UserCall)this.asUser().with(AccountManagement.class)).call(() -> {
            String name = TestUtils.uid((String)"A");
            return this.accountService.create(new AccountInput(name, "Test " + name, name + "@test.com", "test", (Collection)accountGroups.stream().map(Entity::id).collect(Collectors.toList())));
        });
    }

    protected Account doCreateAccountWithGlobalRole(String role) throws Exception {
        Account account = this.doCreateAccount();
        return ((UserCall)this.asUser().with(AccountManagement.class)).call(() -> {
            this.accountService.saveGlobalPermission(PermissionTargetType.ACCOUNT, account.id(), new PermissionInput(role));
            return this.accountService.withACL(AuthenticatedAccount.of((Account)account));
        });
    }

    protected Account doCreateAccountWithProjectRole(Project project, String role) throws Exception {
        Account account = this.doCreateAccount();
        return ((UserCall)this.asUser().with((ProjectEntity)project, ProjectAuthorisationMgt.class)).call(() -> {
            this.accountService.saveProjectPermission(project.getId(), PermissionTargetType.ACCOUNT, account.id(), new PermissionInput(role));
            return this.accountService.withACL(AuthenticatedAccount.of((Account)account));
        });
    }

    protected AccountGroup doCreateAccountGroupWithGlobalRole(String role) throws Exception {
        AccountGroup group = this.doCreateAccountGroup();
        return ((UserCall)this.asUser().with(AccountGroupManagement.class)).call(() -> {
            this.accountService.saveGlobalPermission(PermissionTargetType.GROUP, group.id(), new PermissionInput(role));
            return group;
        });
    }

    protected <T> void setProperty(ProjectEntity projectEntity, Class<? extends PropertyType<T>> propertyTypeClass, T data) throws Exception {
        ((UserCall)this.asUser().with(projectEntity, ProjectEdit.class)).execute(() -> this.propertyService.editProperty(projectEntity, propertyTypeClass, data));
    }

    protected <T> T getProperty(ProjectEntity projectEntity, Class<? extends PropertyType<T>> propertyTypeClass) throws Exception {
        return (T)((UserCall)this.asUser().with(projectEntity, ProjectEdit.class)).call(() -> this.propertyService.getProperty(projectEntity, propertyTypeClass).getValue());
    }

    protected Project doCreateProject() throws Exception {
        return this.doCreateProject(AbstractServiceTestSupport.nameDescription());
    }

    protected Project doCreateProject(NameDescription nameDescription) throws Exception {
        return ((UserCall)this.asUser().with(ProjectCreation.class)).call(() -> this.structureService.newProject(Project.of((NameDescription)nameDescription)));
    }

    protected Branch doCreateBranch() throws Exception {
        return this.doCreateBranch(this.doCreateProject(), AbstractServiceTestSupport.nameDescription());
    }

    protected Branch doCreateBranch(Project project, NameDescription nameDescription) throws Exception {
        return ((UserCall)this.asUser().with(project.id(), BranchCreate.class)).call(() -> this.structureService.newBranch(Branch.of((Project)project, (NameDescription)nameDescription)));
    }

    protected Build doCreateBuild() throws Exception {
        return this.doCreateBuild(this.doCreateBranch(), AbstractServiceTestSupport.nameDescription());
    }

    protected Build doCreateBuild(Branch branch, NameDescription nameDescription) throws Exception {
        return this.doCreateBuild(branch, nameDescription, Signature.of((String)"test"));
    }

    protected Build doCreateBuild(Branch branch, NameDescription nameDescription, Signature signature) throws Exception {
        return ((UserCall)this.asUser().with(branch.projectId(), BuildCreate.class)).call(() -> this.structureService.newBuild(Build.of((Branch)branch, (NameDescription)nameDescription, (Signature)signature)));
    }

    public ValidationRun doValidateBuild(Build build, ValidationStamp vs, ValidationRunStatusID statusId) throws Exception {
        return ((UserCall)this.asUser().with((ProjectEntity)build, ValidationRunCreate.class)).call(() -> this.structureService.newValidationRun(ValidationRun.of((Build)build, (ValidationStamp)vs, (int)1, (Signature)Signature.of((String)"test"), (ValidationRunStatusID)statusId, (String)"")));
    }

    public ValidationRun doValidateBuild(Build build, String vsName, ValidationRunStatusID statusId) throws Exception {
        ValidationStamp vs = this.doCreateValidationStamp(build.getBranch(), NameDescription.nd((String)vsName, (String)""));
        return this.doValidateBuild(build, vs, statusId);
    }

    protected PromotionLevel doCreatePromotionLevel() throws Exception {
        return this.doCreatePromotionLevel(this.doCreateBranch(), AbstractServiceTestSupport.nameDescription());
    }

    protected PromotionLevel doCreatePromotionLevel(Branch branch, NameDescription nameDescription) throws Exception {
        return ((UserCall)this.asUser().with(branch.projectId(), PromotionLevelCreate.class)).call(() -> this.structureService.newPromotionLevel(PromotionLevel.of((Branch)branch, (NameDescription)nameDescription)));
    }

    protected ValidationStamp doCreateValidationStamp() throws Exception {
        return this.doCreateValidationStamp(this.doCreateBranch(), AbstractServiceTestSupport.nameDescription());
    }

    public ValidationStamp doCreateValidationStamp(Branch branch, NameDescription nameDescription) throws Exception {
        return ((UserCall)this.asUser().with(branch.getProject().id(), ValidationStampCreate.class)).call(() -> this.structureService.newValidationStamp(ValidationStamp.of((Branch)branch, (NameDescription)nameDescription)));
    }

    protected PromotionRun doPromote(Build build, PromotionLevel promotionLevel, String description) throws Exception {
        return ((UserCall)this.asUser().with(build.projectId(), PromotionRunCreate.class)).call(() -> this.structureService.newPromotionRun(PromotionRun.of((Build)build, (PromotionLevel)promotionLevel, (Signature)Signature.of((String)"test"), (String)description)));
    }

    protected <T> void doSetProperty(ProjectEntity entity, Class<? extends PropertyType<T>> propertyType, T data) throws Exception {
        ((UserCall)this.asUser().with(entity, ProjectEdit.class)).call(() -> this.propertyService.editProperty(entity, propertyType, data));
    }

    protected UserCall asUser() {
        return new UserCall();
    }

    protected AdminCall asAdmin() {
        return new AdminCall();
    }

    protected AnonymousCall asAnonymous() {
        return new AnonymousCall();
    }

    protected UserCall asUserWithView(ProjectEntity ... entities) {
        UserCall user = this.asUser();
        for (ProjectEntity entity : entities) {
            user = (UserCall)user.withView(entity);
        }
        return user;
    }

    protected AccountCall asAccount(Account account) {
        return new AccountCall(account);
    }

    protected AccountCall asGlobalRole(String role) throws Exception {
        return new AccountCall(this.doCreateAccountWithGlobalRole(role));
    }

    protected <T> T view(ProjectEntity projectEntity, Callable<T> callable) throws Exception {
        return ((UserCall)this.asUser().with(projectEntity.projectId(), ProjectView.class)).call(callable);
    }

    public void grantViewToAll(boolean grantViewToAll) {
        try {
            ((UserCall)this.asUser().with(GlobalSettings.class)).execute(() -> this.settingsManagerService.saveSettings((Object)SecuritySettings.of().withGrantProjectViewToAll(grantViewToAll)));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot set GrantViewToAll settings", ex);
        }
    }

    protected <T> T withNoGrantViewToAll(Callable<T> task) throws Exception {
        this.grantViewToAll(false);
        try {
            T t = task.call();
            return t;
        }
        finally {
            this.grantViewToAll(false);
        }
    }

    protected static class AdminCall
    extends AccountCall<AdminCall> {
        public AdminCall() {
            super("admin", SecurityRole.ADMINISTRATOR);
        }
    }

    protected static class UserCall
    extends AccountCall<UserCall> {
        public UserCall() {
            super("user", SecurityRole.USER);
        }

        public AccountCall withId(int id) {
            return new AccountCall(this.account.withId(ID.of((int)id)));
        }
    }

    protected static class AccountCall<T extends AccountCall<T>>
    extends AbstractContextCall {
        protected final Account account;

        public AccountCall(Account account) {
            this.account = account;
        }

        public AccountCall(String name, SecurityRole role) {
            this(Account.of((String)name, (String)name, (String)(name + "@test.com"), (SecurityRole)role, (AuthenticationSource)AuthenticationSource.none()));
        }

        @SafeVarargs
        public final T with(Class<? extends GlobalFunction> ... fn) {
            this.account.withGlobalRole(Optional.of(new GlobalRole("test", "Test global role", "", (Set)ImmutableSet.copyOf((Object[])fn), Collections.emptySet())));
            return (T)this;
        }

        public T with(int projectId, Class<? extends ProjectFunction> fn) {
            this.account.withProjectRole(new ProjectRoleAssociation(projectId, new ProjectRole("test", "Test", "", Collections.singleton(fn))));
            return (T)this;
        }

        public T with(ProjectEntity e, Class<? extends ProjectFunction> fn) {
            return this.with(e.projectId(), fn);
        }

        public T withView(ProjectEntity e) {
            return this.with(e, ProjectView.class);
        }

        @Override
        protected void contextSetup() {
            SecurityContextImpl context = new SecurityContextImpl();
            TestingAuthenticationToken authentication = new TestingAuthenticationToken(() -> this.account, (Object)"", new String[]{this.account.getRole().name()});
            context.setAuthentication((Authentication)authentication);
            SecurityContextHolder.setContext((SecurityContext)context);
        }
    }

    protected static class AnonymousCall
    extends AbstractContextCall {
        protected AnonymousCall() {
        }

        @Override
        protected void contextSetup() {
            SecurityContextImpl context = new SecurityContextImpl();
            context.setAuthentication(null);
            SecurityContextHolder.setContext((SecurityContext)context);
        }
    }

    protected static abstract class AbstractContextCall
    implements ContextCall {
        protected AbstractContextCall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T call(Callable<T> call) throws Exception {
            SecurityContext oldContext = SecurityContextHolder.getContext();
            try {
                this.contextSetup();
                T t = call.call();
                return t;
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)oldContext);
            }
        }

        public void execute(Runnable task) throws Exception {
            this.call(() -> {
                task.run();
                return null;
            });
        }

        protected abstract void contextSetup();
    }

    protected static interface ContextCall {
        public <T> T call(Callable<T> var1) throws Exception;
    }
}

