/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.template;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.template.SVNBranchesTemplateSynchronisationSourceConfig;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.support.AbstractTemplateSynchronisationSource;
import net.nemerosa.ontrack.tx.TransactionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNBranchesTemplateSynchronisationSource
extends AbstractTemplateSynchronisationSource<SVNBranchesTemplateSynchronisationSourceConfig> {
    private final SVNService svnService;
    private final TransactionService transactionService;

    @Autowired
    public SVNBranchesTemplateSynchronisationSource(SVNService svnService, TransactionService transactionService) {
        super(SVNBranchesTemplateSynchronisationSourceConfig.class);
        this.svnService = svnService;
        this.transactionService = transactionService;
    }

    public String getId() {
        return "svn-branches";
    }

    public String getName() {
        return "SVN branches";
    }

    public boolean isApplicable(Branch branch) {
        return this.svnService.getSVNRepository(branch).isPresent();
    }

    public Form getForm(Branch branch) {
        return SVNBranchesTemplateSynchronisationSourceConfig.form();
    }

    public List<String> getBranchNames(Branch branch, SVNBranchesTemplateSynchronisationSourceConfig config) {
        return (List)this.transactionService.doInTransaction(() -> {
            Predicate filter = config.getFilter();
            return this.svnService.getBranches(branch).stream().filter(filter).sorted().collect(Collectors.toList());
        });
    }
}

