/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.scm.model.SCMPathInfo;
import net.nemerosa.ontrack.extension.svn.client.SVNClient;
import net.nemerosa.ontrack.extension.svn.db.SVNEventDao;
import net.nemerosa.ontrack.extension.svn.db.SVNIssueRevisionDao;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.db.SVNRepositoryDao;
import net.nemerosa.ontrack.extension.svn.db.SVNRevisionDao;
import net.nemerosa.ontrack.extension.svn.db.TCopyEvent;
import net.nemerosa.ontrack.extension.svn.db.TRevision;
import net.nemerosa.ontrack.extension.svn.model.MissingSVNProjectConfigurationException;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevision;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.model.SVNRepositoryIssue;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionPath;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionPaths;
import net.nemerosa.ontrack.extension.svn.model.SVNSyncInfo;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNSyncProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNSyncPropertyType;
import net.nemerosa.ontrack.extension.svn.service.SVNConfigurationService;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.service.SVNServiceUtils;
import net.nemerosa.ontrack.extension.svn.support.SVNUtils;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SVNServiceImpl
implements SVNService {
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final IssueServiceRegistry issueServiceRegistry;
    private final SVNConfigurationService configurationService;
    private final SVNRevisionDao revisionDao;
    private final SVNIssueRevisionDao issueRevisionDao;
    private final SVNEventDao eventDao;
    private final SVNRepositoryDao repositoryDao;
    private final SVNClient svnClient;
    private final TransactionService transactionService;
    private final SecurityService securityService;

    @Autowired
    public SVNServiceImpl(StructureService structureService, PropertyService propertyService, IssueServiceRegistry issueServiceRegistry, SVNConfigurationService configurationService, SVNRevisionDao revisionDao, SVNIssueRevisionDao issueRevisionDao, SVNEventDao eventDao, SVNRepositoryDao repositoryDao, SVNClient svnClient, TransactionService transactionService, SecurityService securityService) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.issueServiceRegistry = issueServiceRegistry;
        this.configurationService = configurationService;
        this.revisionDao = revisionDao;
        this.issueRevisionDao = issueRevisionDao;
        this.eventDao = eventDao;
        this.repositoryDao = repositoryDao;
        this.svnClient = svnClient;
        this.transactionService = transactionService;
        this.securityService = securityService;
    }

    @Override
    public SVNRevisionInfo getRevisionInfo(SVNRepository repository, long revision) {
        TRevision t = this.revisionDao.get(repository.getId(), revision);
        return new SVNRevisionInfo(t.getRevision(), t.getAuthor(), t.getCreation(), t.getBranch(), t.getMessage(), repository.getRevisionBrowsingURL(t.getRevision()));
    }

    @Override
    public SVNRevisionPaths getRevisionPaths(SVNRepository repository, long revision) {
        List<SVNRevisionPath> revisionPaths = this.svnClient.getRevisionPaths(repository, revision);
        return new SVNRevisionPaths(this.getRevisionInfo(repository, revision), revisionPaths);
    }

    @Override
    public List<Long> getRevisionsForIssueKey(SVNRepository repository, String key) {
        return this.issueRevisionDao.findRevisionsByIssue(repository.getId(), key);
    }

    @Override
    public SVNRepository getRepository(String name) {
        SVNConfiguration configuration = (SVNConfiguration)this.configurationService.getConfiguration(name);
        return SVNRepository.of(this.repositoryDao.getOrCreateByName(configuration.getName()), configuration, this.issueServiceRegistry.getConfiguredIssueService(configuration.getIssueServiceConfigurationIdentifier()));
    }

    @Override
    public Optional<SVNRepositoryIssue> searchIssues(SVNRepository repository, String token) {
        ConfiguredIssueService configuredIssueService = repository.getConfiguredIssueService();
        if (configuredIssueService != null) {
            return configuredIssueService.getIssueId(token).flatMap(searchKey -> this.issueRevisionDao.findIssueByKey(repository.getId(), (String)searchKey)).map(key -> new SVNRepositoryIssue(repository, configuredIssueService.getIssue(key)));
        }
        return Optional.empty();
    }

    @Override
    public SVNChangeLogRevision createChangeLogRevision(SVNRepository repository, SVNRevisionInfo basicInfo) {
        return SVNServiceUtils.createChangeLogRevision(repository, basicInfo.getPath(), 0, basicInfo.getRevision(), basicInfo.getMessage(), basicInfo.getAuthor(), basicInfo.getDateTime());
    }

    @Override
    public void forEachConfiguredBranch(Predicate<SVNProjectConfigurationProperty> projectConfigurationPredicate, BiConsumer<Branch, SVNBranchConfigurationProperty> branchConsumer) {
        for (Project project : this.structureService.getProjectList()) {
            Property projectSvnConfig = this.propertyService.getProperty((ProjectEntity)project, SVNProjectConfigurationPropertyType.class);
            if (projectSvnConfig.isEmpty() || !projectConfigurationPredicate.test((SVNProjectConfigurationProperty)projectSvnConfig.getValue())) continue;
            this.structureService.getBranchesForProject(project.getId()).stream().filter(branch -> this.propertyService.hasProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class)).forEach(branch -> {
                SVNBranchConfigurationProperty branchConfiguration = (SVNBranchConfigurationProperty)this.propertyService.getProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class).getValue();
                branchConsumer.accept((Branch)branch, branchConfiguration);
            });
        }
    }

    @Override
    public SVNSyncInfo getSyncInfo(ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        return new SVNSyncInfo(branch, (SVNSyncProperty)this.propertyService.getProperty((ProjectEntity)branch, SVNSyncPropertyType.class).getValue());
    }

    @Override
    public Optional<SVNRepository> getSVNRepository(Branch branch) {
        Property projectConfiguration = this.propertyService.getProperty((ProjectEntity)branch.getProject(), SVNProjectConfigurationPropertyType.class);
        if (projectConfiguration.isEmpty()) {
            return Optional.empty();
        }
        SVNConfiguration configuration = ((SVNProjectConfigurationProperty)projectConfiguration.getValue()).getConfiguration();
        return Optional.of(this.getRepository(configuration.getName()));
    }

    @Override
    public SVNRepository getRequiredSVNRepository(Branch branch) {
        return this.getSVNRepository(branch).orElseThrow(() -> new MissingSVNProjectConfigurationException(branch.getProject().getName()));
    }

    @Override
    public List<String> getBranches(Branch branch) {
        Property svnProperty = this.propertyService.getProperty((ProjectEntity)branch.getProject(), SVNProjectConfigurationPropertyType.class);
        if (svnProperty.isEmpty()) {
            return Collections.emptyList();
        }
        SVNRepository repository = this.getSVNRepository(branch).get();
        String projectPath = ((SVNProjectConfigurationProperty)svnProperty.getValue()).getProjectPath();
        String branchesDir = projectPath.endsWith("/trunk") ? projectPath.replace("/trunk", "/branches") : projectPath + "/branches";
        return this.svnClient.getBranches(repository, SVNUtils.toURL(repository.getUrl(branchesDir)));
    }

    public Optional<String> download(Branch branch, String path) {
        this.securityService.checkProjectFunction((ProjectEntity)branch, ProjectConfig.class);
        Optional<SVNRepository> oSvnRepository = this.getSVNRepository(branch);
        if (oSvnRepository.isPresent()) {
            Optional oSvnBranchConfigurationProperty = this.propertyService.getProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class).option();
            if (oSvnBranchConfigurationProperty.isPresent()) {
                String pathInBranch = ((SVNBranchConfigurationProperty)oSvnBranchConfigurationProperty.get()).getCuredBranchPath() + "/" + StringUtils.stripStart((String)path, (String)"/");
                try (Transaction ignored = this.transactionService.start();){
                    Optional<String> optional = this.svnClient.download(oSvnRepository.get(), pathInBranch);
                    return optional;
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public TCopyEvent getLastCopyEvent(int id, String tagPath, long maxValue) {
        return this.eventDao.getLastCopyEvent(id, tagPath, maxValue);
    }

    @Override
    public Optional<String> getTagPathForTagName(SVNRepository svnRepository, String branchPath, String tagName) {
        return this.getBasePath(svnRepository, branchPath).map(basePath -> basePath + "/tags/" + tagName);
    }

    @Override
    public Optional<String> getBasePath(SVNRepository svnRepository, String branchPath) {
        return this.svnClient.getBasePath(svnRepository, branchPath);
    }

    @Override
    public SVNLocation getFirstCopyAfter(SVNRepository repository, SVNLocation location) {
        return this.eventDao.getFirstCopyAfter(repository.getId(), location);
    }

    public Optional<SCMPathInfo> getSCMPathInfo(Branch branch) {
        return this.propertyService.getProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class).option().map(property -> {
            SVNRepository svnRepository = this.getSVNRepository(branch).get();
            return new SCMPathInfo("svn", svnRepository.getUrl(property.getCuredBranchPath()), null, null);
        });
    }
}

