/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.service;

import java.util.Objects;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.support.AbstractConfigurationService;
import net.nemerosa.ontrack.extension.svn.client.SVNClient;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.db.SVNRepositoryDao;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.model.SVNURLFormatException;
import net.nemerosa.ontrack.extension.svn.service.SVNConfigurationService;
import net.nemerosa.ontrack.extension.svn.support.SVNUtils;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventPostService;
import net.nemerosa.ontrack.model.security.EncryptionService;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.Configuration;
import net.nemerosa.ontrack.model.support.ConfigurationRepository;
import net.nemerosa.ontrack.model.support.ConfigurationValidationException;
import net.nemerosa.ontrack.model.support.ConnectionResult;
import net.nemerosa.ontrack.model.support.OntrackConfigProperties;
import net.nemerosa.ontrack.model.support.UserPasswordConfiguration;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

@Service
@Transactional
public class SVNConfigurationServiceImpl
extends AbstractConfigurationService<SVNConfiguration>
implements SVNConfigurationService {
    private final SVNRepositoryDao repositoryDao;
    private final TransactionService transactionService;
    private final SVNClient svnClient;
    private final IssueServiceRegistry issueServiceRegistry;

    @Autowired
    public SVNConfigurationServiceImpl(ConfigurationRepository configurationRepository, SecurityService securityService, EncryptionService encryptionService, SVNRepositoryDao repositoryDao, EventPostService eventPostService, EventFactory eventFactory, OntrackConfigProperties ontrackConfigProperties, TransactionService transactionService, SVNClient svnClient, IssueServiceRegistry issueServiceRegistry) {
        super(SVNConfiguration.class, configurationRepository, securityService, encryptionService, eventPostService, eventFactory, ontrackConfigProperties);
        this.repositoryDao = repositoryDao;
        this.transactionService = transactionService;
        this.svnClient = svnClient;
        this.issueServiceRegistry = issueServiceRegistry;
    }

    public void deleteConfiguration(String name) {
        super.deleteConfiguration(name);
        Integer id = this.repositoryDao.findByName(name);
        if (id != null) {
            this.repositoryDao.delete(id);
        }
    }

    protected void validateAndCheck(SVNConfiguration configuration) {
        ConfiguredIssueService configuredIssueService;
        super.validateAndCheck((UserPasswordConfiguration)configuration);
        String issueServiceConfigurationIdentifier = configuration.getIssueServiceConfigurationIdentifier();
        if (StringUtils.isNotBlank((CharSequence)issueServiceConfigurationIdentifier) && ((configuredIssueService = this.issueServiceRegistry.getConfiguredIssueService(issueServiceConfigurationIdentifier)) == null || configuredIssueService.getIssueServiceConfiguration() == null)) {
            throw new ConfigurationValidationException((Configuration)configuration, String.format("Issue service configuration cannot be validated: %s", issueServiceConfigurationIdentifier));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ConnectionResult validate(SVNConfiguration configuration) {
        String url = configuration.getUrl();
        if (StringUtils.endsWith((CharSequence)url, (CharSequence)"/")) {
            throw new SVNURLFormatException("The Subversion URL must not end with a slash: %s", url);
        }
        try (Transaction ignored = this.transactionService.start();){
            SVNRepository repository = SVNRepository.of(0, configuration, null);
            SVNURL svnurl = SVNUtils.toURL(configuration.getUrl());
            if (!this.svnClient.exists(repository, svnurl, SVNRevision.HEAD)) {
                ConnectionResult connectionResult = ConnectionResult.error((String)(configuration.getUrl() + " does not exist."));
                return connectionResult;
            }
            SVNInfo info = this.svnClient.getInfo(repository, svnurl, SVNRevision.HEAD);
            if (!Objects.equals(info.getRepositoryRootURL(), svnurl)) {
                ConnectionResult connectionResult = ConnectionResult.error((String)(configuration.getUrl() + " must be the root of the repository."));
                return connectionResult;
            }
            ConnectionResult connectionResult = ConnectionResult.ok();
            return connectionResult;
        }
        catch (Exception ex) {
            return ConnectionResult.error((String)ex.getMessage());
        }
    }
}

