/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.property;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.common.MapBuilder;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNSyncProperty;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNSyncPropertyType
extends AbstractPropertyType<SVNSyncProperty> {
    private final PropertyService propertyService;

    @Autowired
    public SVNSyncPropertyType(SVNExtensionFeature extensionFeature, PropertyService propertyService) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
    }

    public String getName() {
        return "SVN synchronisation";
    }

    public String getDescription() {
        return "Allows the synchronisation of the builds with the tags in Subversion.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.BRANCH);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class) && this.propertyService.hasProperty(entity, SVNBranchConfigurationPropertyType.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public Form getEditionForm(ProjectEntity entity, SVNSyncProperty value) {
        return Form.create().with((Field)((YesNo)((YesNo)YesNo.of((String)"override").label("Override builds")).help("Can the existing builds be overridden by a synchronisation? If yes, the existing validation and promotion runs would be lost as well.")).value((Object)(value != null && value.isOverride() ? 1 : 0))).with((Field)((Int)((Int)Int.of((String)"interval").label("Sync. interval (min)")).min(0).max(10080).help("Interval in minutes for the synchronisation. If 0, the synchronisation must be done manually")).value((Object)(value != null ? value.getInterval() : 0)));
    }

    public JsonNode forStorage(SVNSyncProperty value) {
        return SVNSyncPropertyType.format((Object)MapBuilder.params().with((Object)"override", (Object)value.isOverride()).with((Object)"interval", (Object)value.getInterval()).get());
    }

    public SVNSyncProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public SVNSyncProperty fromStorage(JsonNode node) {
        boolean override = node.path("override").asBoolean();
        int interval = node.path("interval").asInt();
        if (interval < 0) {
            interval = 0;
        }
        return new SVNSyncProperty(override, interval);
    }

    public String getSearchKey(SVNSyncProperty value) {
        return "";
    }

    public SVNSyncProperty replaceValue(SVNSyncProperty value, Function<String, String> replacementFunction) {
        return value;
    }
}

