/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.property;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLinkService;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.support.ConfiguredBuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.support.TagNameSvnRevisionLink;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.ServiceConfigurator;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;
import net.nemerosa.ontrack.model.structure.ServiceConfigurationSource;
import net.nemerosa.ontrack.model.support.NoConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNBranchConfigurationPropertyType
extends AbstractPropertyType<SVNBranchConfigurationProperty> {
    private final PropertyService propertyService;
    private final BuildSvnRevisionLinkService buildSvnRevisionLinkService;
    private final TagNameSvnRevisionLink tagNameSvnRevisionLink;

    @Autowired
    public SVNBranchConfigurationPropertyType(SVNExtensionFeature extensionFeature, PropertyService propertyService, BuildSvnRevisionLinkService buildSvnRevisionLinkService, TagNameSvnRevisionLink tagNameSvnRevisionLink) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
        this.buildSvnRevisionLinkService = buildSvnRevisionLinkService;
        this.tagNameSvnRevisionLink = tagNameSvnRevisionLink;
    }

    public String getName() {
        return "SVN configuration";
    }

    public String getDescription() {
        return "Associates the branch with Subversion.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.BRANCH);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity.projectId(), ProjectConfig.class) && this.propertyService.hasProperty((ProjectEntity)entity.getProject(), SVNProjectConfigurationPropertyType.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, SVNBranchConfigurationProperty value) {
        return Form.create().with((Field)((Text)((Text)Text.of((String)"branchPath").label("Branch path")).help("Path of the branch in the Subversion repository. The path is relative to the root of the repository.")).value((Object)(value != null ? value.getBranchPath() : "/project/branches/xxx"))).with((Field)((ServiceConfigurator)((ServiceConfigurator)ServiceConfigurator.of((String)"buildRevisionLink").label("Build revision link")).help("Link between the builds and the Svn revisions.")).sources(this.buildSvnRevisionLinkService.getLinks().stream().map(link -> new ServiceConfigurationSource(link.getId(), link.getName(), link.getForm())).collect(Collectors.toList())).value((Object)(value != null ? value.getBuildRevisionLink() : null)));
    }

    public SVNBranchConfigurationProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public SVNBranchConfigurationProperty fromStorage(JsonNode node) {
        ConfiguredBuildSvnRevisionLink<Object> configuredBuildSvnRevisionLink;
        String branchPath = node.path("branchPath").asText();
        this.validateNotBlank(branchPath, "The branch path must not be empty");
        if (node.has("buildRevisionLink")) {
            JsonNode linkNode = node.get("buildRevisionLink");
            configuredBuildSvnRevisionLink = this.parseBuildRevisionLink(linkNode);
        } else {
            configuredBuildSvnRevisionLink = new ConfiguredBuildSvnRevisionLink<NoConfig>(this.tagNameSvnRevisionLink, NoConfig.INSTANCE);
        }
        return new SVNBranchConfigurationProperty(branchPath, configuredBuildSvnRevisionLink.toServiceConfiguration());
    }

    private <T> ConfiguredBuildSvnRevisionLink<T> parseBuildRevisionLink(JsonNode linkNode) {
        String linkId = JsonUtils.get((JsonNode)linkNode, (String)"id");
        JsonNode linkDataNode = linkNode.get("data");
        return this.buildSvnRevisionLinkService.getConfiguredBuildSvnRevisionLink(linkId, linkDataNode);
    }

    public String getSearchKey(SVNBranchConfigurationProperty value) {
        return value.getBranchPath();
    }

    public SVNBranchConfigurationProperty replaceValue(SVNBranchConfigurationProperty value, Function<String, String> replacementFunction) {
        return new SVNBranchConfigurationProperty(replacementFunction.apply(value.getBranchPath()), this.replaceBuildRevisionLink(value.getBuildRevisionLink(), replacementFunction));
    }

    private <T> ServiceConfiguration replaceBuildRevisionLink(ServiceConfiguration configuration, Function<String, String> replacementFunction) {
        String linkId = configuration.getId();
        BuildSvnRevisionLink<?> link = this.buildSvnRevisionLinkService.getLink(linkId);
        Object linkData = link.parseData(configuration.getData());
        Object clonedData = link.clone(linkData, replacementFunction);
        JsonNode node = link.toJson(clonedData);
        return new ServiceConfiguration(linkId, node);
    }
}

