/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;

public class SVNRevisionInfo {
    private final long revision;
    private final String author;
    private final LocalDateTime dateTime;
    private final String path;
    private final String message;
    private final String revisionUrl;

    public SVNLocation toLocation() {
        return new SVNLocation(this.path, this.revision);
    }

    @ConstructorProperties(value={"revision", "author", "dateTime", "path", "message", "revisionUrl"})
    public SVNRevisionInfo(long revision, String author, LocalDateTime dateTime, String path, String message, String revisionUrl) {
        this.revision = revision;
        this.author = author;
        this.dateTime = dateTime;
        this.path = path;
        this.message = message;
        this.revisionUrl = revisionUrl;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public String getPath() {
        return this.path;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRevisionUrl() {
        return this.revisionUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNRevisionInfo)) {
            return false;
        }
        SVNRevisionInfo other = (SVNRevisionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        LocalDateTime this$dateTime = this.getDateTime();
        LocalDateTime other$dateTime = other.getDateTime();
        if (this$dateTime == null ? other$dateTime != null : !((Object)this$dateTime).equals(other$dateTime)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$revisionUrl = this.getRevisionUrl();
        String other$revisionUrl = other.getRevisionUrl();
        return !(this$revisionUrl == null ? other$revisionUrl != null : !this$revisionUrl.equals(other$revisionUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNRevisionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $revision = this.getRevision();
        result = result * 59 + (int)($revision >>> 32 ^ $revision);
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        LocalDateTime $dateTime = this.getDateTime();
        result = result * 59 + ($dateTime == null ? 43 : ((Object)$dateTime).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $revisionUrl = this.getRevisionUrl();
        result = result * 59 + ($revisionUrl == null ? 43 : $revisionUrl.hashCode());
        return result;
    }

    public String toString() {
        return "SVNRevisionInfo(revision=" + this.getRevision() + ", author=" + this.getAuthor() + ", dateTime=" + this.getDateTime() + ", path=" + this.getPath() + ", message=" + this.getMessage() + ", revisionUrl=" + this.getRevisionUrl() + ")";
    }
}

