/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;

public class SVNReference {
    private final String path;
    private final String url;
    private final long revision;
    private final LocalDateTime time;

    public SVNLocation toLocation() {
        return new SVNLocation(this.path, this.revision);
    }

    @ConstructorProperties(value={"path", "url", "revision", "time"})
    public SVNReference(String path, String url, long revision, LocalDateTime time) {
        this.path = path;
        this.url = url;
        this.revision = revision;
        this.time = time;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public long getRevision() {
        return this.revision;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNReference)) {
            return false;
        }
        SVNReference other = (SVNReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        long $revision = this.getRevision();
        result = result * 59 + (int)($revision >>> 32 ^ $revision);
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public String toString() {
        return "SVNReference(path=" + this.getPath() + ", url=" + this.getUrl() + ", revision=" + this.getRevision() + ", time=" + this.getTime() + ")";
    }
}

