/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.nemerosa.ontrack.extension.svn.model.SVNReference;

public class SVNHistory {
    private final List<SVNReference> references;

    public SVNHistory() {
        this(Collections.emptyList());
    }

    public SVNHistory(SVNReference ... references) {
        this(Arrays.asList(references));
    }

    public SVNHistory add(SVNReference reference) {
        ArrayList<SVNReference> target = new ArrayList<SVNReference>(this.references);
        target.add(reference);
        return new SVNHistory(target);
    }

    public SVNHistory truncateAbove(int index) {
        return new SVNHistory(this.references.subList(index + 1, this.references.size()));
    }

    @JsonIgnore
    public long getRevision() {
        return this.references.get(0).getRevision();
    }

    public List<SVNReference> getReferences() {
        return this.references;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNHistory)) {
            return false;
        }
        SVNHistory other = (SVNHistory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SVNReference> this$references = this.getReferences();
        List<SVNReference> other$references = other.getReferences();
        return !(this$references == null ? other$references != null : !((Object)this$references).equals(other$references));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNHistory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SVNReference> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        return result;
    }

    public String toString() {
        return "SVNHistory(references=" + this.getReferences() + ")";
    }

    @ConstructorProperties(value={"references"})
    protected SVNHistory(List<SVNReference> references) {
        this.references = references;
    }
}

