/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogCommit;

public class SVNChangeLogRevision
implements SCMChangeLogCommit {
    private final String path;
    private final int level;
    private final long revision;
    private final String author;
    private final LocalDateTime revisionDate;
    private final String message;
    private final String revisionUrl;
    private final String formattedMessage;

    public String getLink() {
        return this.revisionUrl;
    }

    public String getId() {
        return String.valueOf(this.revision);
    }

    public LocalDateTime getTimestamp() {
        return this.revisionDate;
    }

    public String getAuthorEmail() {
        return null;
    }

    @ConstructorProperties(value={"path", "level", "revision", "author", "revisionDate", "message", "revisionUrl", "formattedMessage"})
    public SVNChangeLogRevision(String path, int level, long revision, String author, LocalDateTime revisionDate, String message, String revisionUrl, String formattedMessage) {
        this.path = path;
        this.level = level;
        this.revision = revision;
        this.author = author;
        this.revisionDate = revisionDate;
        this.message = message;
        this.revisionUrl = revisionUrl;
        this.formattedMessage = formattedMessage;
    }

    public String getPath() {
        return this.path;
    }

    public int getLevel() {
        return this.level;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public LocalDateTime getRevisionDate() {
        return this.revisionDate;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRevisionUrl() {
        return this.revisionUrl;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNChangeLogRevision)) {
            return false;
        }
        SVNChangeLogRevision other = (SVNChangeLogRevision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        LocalDateTime this$revisionDate = this.getRevisionDate();
        LocalDateTime other$revisionDate = other.getRevisionDate();
        if (this$revisionDate == null ? other$revisionDate != null : !((Object)this$revisionDate).equals(other$revisionDate)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$revisionUrl = this.getRevisionUrl();
        String other$revisionUrl = other.getRevisionUrl();
        if (this$revisionUrl == null ? other$revisionUrl != null : !this$revisionUrl.equals(other$revisionUrl)) {
            return false;
        }
        String this$formattedMessage = this.getFormattedMessage();
        String other$formattedMessage = other.getFormattedMessage();
        return !(this$formattedMessage == null ? other$formattedMessage != null : !this$formattedMessage.equals(other$formattedMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNChangeLogRevision;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + this.getLevel();
        long $revision = this.getRevision();
        result = result * 59 + (int)($revision >>> 32 ^ $revision);
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        LocalDateTime $revisionDate = this.getRevisionDate();
        result = result * 59 + ($revisionDate == null ? 43 : ((Object)$revisionDate).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $revisionUrl = this.getRevisionUrl();
        result = result * 59 + ($revisionUrl == null ? 43 : $revisionUrl.hashCode());
        String $formattedMessage = this.getFormattedMessage();
        result = result * 59 + ($formattedMessage == null ? 43 : $formattedMessage.hashCode());
        return result;
    }

    public String toString() {
        return "SVNChangeLogRevision(path=" + this.getPath() + ", level=" + this.getLevel() + ", revision=" + this.getRevision() + ", author=" + this.getAuthor() + ", revisionDate=" + this.getRevisionDate() + ", message=" + this.getMessage() + ", revisionUrl=" + this.getRevisionUrl() + ", formattedMessage=" + this.getFormattedMessage() + ")";
    }
}

