/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogIssue;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionInfo;

public class SVNChangeLogIssue
extends SCMChangeLogIssue {
    private final List<SVNRevisionInfo> revisions;

    protected SVNChangeLogIssue(Issue issue, List<SVNRevisionInfo> revisions) {
        super(issue);
        this.revisions = revisions;
    }

    public SVNChangeLogIssue(Issue issue) {
        this(issue, Collections.emptyList());
    }

    public SVNChangeLogIssue addRevision(SVNRevisionInfo revision) {
        ArrayList<SVNRevisionInfo> list = new ArrayList<SVNRevisionInfo>(this.revisions);
        list.add(revision);
        return new SVNChangeLogIssue(this.getIssue(), list);
    }

    public SVNRevisionInfo getLastRevision() {
        if (this.revisions != null && !this.revisions.isEmpty()) {
            return this.revisions.get(this.revisions.size() - 1);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNChangeLogIssue)) {
            return false;
        }
        SVNChangeLogIssue other = (SVNChangeLogIssue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<SVNRevisionInfo> this$revisions = this.getRevisions();
        List<SVNRevisionInfo> other$revisions = other.getRevisions();
        return !(this$revisions == null ? other$revisions != null : !((Object)this$revisions).equals(other$revisions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNChangeLogIssue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SVNRevisionInfo> $revisions = this.getRevisions();
        result = result * 59 + ($revisions == null ? 43 : ((Object)$revisions).hashCode());
        return result;
    }

    public List<SVNRevisionInfo> getRevisions() {
        return this.revisions;
    }

    public String toString() {
        return "SVNChangeLogIssue(revisions=" + this.getRevisions() + ")";
    }
}

