/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.nemerosa.ontrack.extension.scm.model.SCMBuildView;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLog;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogFiles;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogIssues;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogReference;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevisions;
import net.nemerosa.ontrack.extension.svn.model.SVNHistory;
import net.nemerosa.ontrack.extension.svn.model.SVNReference;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Project;

public class SVNChangeLog
extends SCMChangeLog<SVNHistory> {
    @JsonIgnore
    private SVNChangeLogRevisions revisions;
    @JsonIgnore
    private SVNChangeLogIssues issues;
    @JsonIgnore
    private SVNChangeLogFiles files;
    @JsonIgnore
    private final SVNRepository repository;

    public SVNChangeLog(String uuid, Project project, SVNRepository repository, SCMBuildView<SVNHistory> scmBuildFrom, SCMBuildView<SVNHistory> scmBuildTo) {
        super(uuid, project, scmBuildFrom, scmBuildTo);
        this.repository = repository;
    }

    public SVNChangeLog withRevisions(SVNChangeLogRevisions revisions) {
        this.revisions = revisions;
        return this;
    }

    public SVNChangeLog withIssues(SVNChangeLogIssues issues) {
        this.issues = issues;
        return this;
    }

    public SVNChangeLog withFiles(SVNChangeLogFiles files) {
        this.files = files;
        return this;
    }

    @JsonIgnore
    public Collection<SVNChangeLogReference> getChangeLogReferences() {
        SVNHistory historyFrom = (SVNHistory)this.getScmBuildFrom().getScm();
        SVNHistory historyTo = (SVNHistory)this.getScmBuildTo().getScm();
        if (historyFrom.getReferences().isEmpty() || historyTo.getReferences().isEmpty()) {
            return Collections.emptyList();
        }
        long fromRevision = historyFrom.getReferences().get(0).getRevision();
        long toRevision = historyTo.getReferences().get(0).getRevision();
        if (toRevision < fromRevision) {
            SVNHistory tmp = historyTo;
            historyTo = historyFrom;
            historyFrom = tmp;
        }
        ImmutableMap historyFromIndex = Maps.uniqueIndex(historyFrom.getReferences(), SVNReference::getPath);
        ArrayList<SVNChangeLogReference> references = new ArrayList<SVNChangeLogReference>();
        for (SVNReference toReference : historyTo.getReferences()) {
            long toRevision2 = toReference.getRevision();
            long fromRevision2 = 0L;
            SVNReference fromReference = (SVNReference)historyFromIndex.get(toReference.getPath());
            if (fromReference != null && (fromRevision2 = fromReference.getRevision()) > toRevision2) {
                long t = toRevision2;
                toRevision2 = fromRevision2;
                fromRevision2 = t;
            }
            references.add(new SVNChangeLogReference(toReference.getPath(), fromRevision2, toRevision2));
        }
        return references;
    }

    @JsonIgnore
    public Branch getBranch() {
        return this.getFrom().getBuild().getBranch();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNChangeLog)) {
            return false;
        }
        SVNChangeLog other = (SVNChangeLog)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SVNChangeLogRevisions this$revisions = this.getRevisions();
        SVNChangeLogRevisions other$revisions = other.getRevisions();
        if (this$revisions == null ? other$revisions != null : !((Object)this$revisions).equals(other$revisions)) {
            return false;
        }
        SVNChangeLogIssues this$issues = this.getIssues();
        SVNChangeLogIssues other$issues = other.getIssues();
        if (this$issues == null ? other$issues != null : !((Object)this$issues).equals(other$issues)) {
            return false;
        }
        SVNChangeLogFiles this$files = this.getFiles();
        SVNChangeLogFiles other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        SVNRepository this$repository = this.getRepository();
        SVNRepository other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNChangeLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SVNChangeLogRevisions $revisions = this.getRevisions();
        result = result * 59 + ($revisions == null ? 43 : ((Object)$revisions).hashCode());
        SVNChangeLogIssues $issues = this.getIssues();
        result = result * 59 + ($issues == null ? 43 : ((Object)$issues).hashCode());
        SVNChangeLogFiles $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        SVNRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        return result;
    }

    public SVNChangeLogRevisions getRevisions() {
        return this.revisions;
    }

    public SVNChangeLogIssues getIssues() {
        return this.issues;
    }

    public SVNChangeLogFiles getFiles() {
        return this.files;
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    public void setRevisions(SVNChangeLogRevisions revisions) {
        this.revisions = revisions;
    }

    public void setIssues(SVNChangeLogIssues issues) {
        this.issues = issues;
    }

    public void setFiles(SVNChangeLogFiles files) {
        this.files = files;
    }

    public String toString() {
        return "SVNChangeLog(revisions=" + this.getRevisions() + ", issues=" + this.getIssues() + ", files=" + this.getFiles() + ", repository=" + this.getRepository() + ")";
    }
}

