/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import java.beans.ConstructorProperties;
import java.util.Collection;

public class BranchRevision {
    private final String path;
    private final long revision;
    private final boolean merge;
    private final boolean complete;

    public BranchRevision(String path, long revision, boolean merge) {
        this(path, revision, merge, false);
    }

    public BranchRevision complete() {
        return new BranchRevision(this.path, this.revision, this.merge, true);
    }

    public static boolean areComplete(Collection<BranchRevision> branchRevisions) {
        return branchRevisions.stream().allMatch(BranchRevision::isComplete);
    }

    public String getPath() {
        return this.path;
    }

    public long getRevision() {
        return this.revision;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BranchRevision)) {
            return false;
        }
        BranchRevision other = (BranchRevision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        if (this.isMerge() != other.isMerge()) {
            return false;
        }
        return this.isComplete() == other.isComplete();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BranchRevision;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        long $revision = this.getRevision();
        result = result * 59 + (int)($revision >>> 32 ^ $revision);
        result = result * 59 + (this.isMerge() ? 79 : 97);
        result = result * 59 + (this.isComplete() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BranchRevision(path=" + this.getPath() + ", revision=" + this.getRevision() + ", merge=" + this.isMerge() + ", complete=" + this.isComplete() + ")";
    }

    @ConstructorProperties(value={"path", "revision", "merge", "complete"})
    protected BranchRevision(String path, long revision, boolean merge, boolean complete) {
        this.path = path;
        this.revision = revision;
        this.merge = merge;
        this.complete = complete;
    }
}

