/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.graphql;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.svn.graphql.SVNConfigurationGQLType;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.service.SVNConfigurationService;
import net.nemerosa.ontrack.graphql.schema.GQLRootQuery;
import net.nemerosa.ontrack.graphql.support.GraphqlUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNConfigurationGQLRootQuery
implements GQLRootQuery {
    private final SVNConfigurationService svnConfigurationService;
    private final SVNConfigurationGQLType svnConfigurationGQLType;

    @Autowired
    public SVNConfigurationGQLRootQuery(SVNConfigurationService svnConfigurationService, SVNConfigurationGQLType svnConfigurationGQLType) {
        this.svnConfigurationService = svnConfigurationService;
        this.svnConfigurationGQLType = svnConfigurationGQLType;
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return GraphQLFieldDefinition.newFieldDefinition().name("svnConfigurations").description("List of SVN configurations").type(GraphqlUtils.stdList((GraphQLType)this.svnConfigurationGQLType.getTypeRef())).argument(a -> a.name("name").description("Configuration name").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(this::getSVNConfigurationList).build();
    }

    private List<SVNConfiguration> getSVNConfigurationList(DataFetchingEnvironment environment) {
        Predicate<SVNConfiguration> filter = GraphqlUtils.getStringArgument((DataFetchingEnvironment)environment, (String)"name").map(s -> c -> StringUtils.equals((CharSequence)s, (CharSequence)c.getName())).orElse(c -> true);
        return this.svnConfigurationService.getConfigurations().stream().filter(filter).collect(Collectors.toList());
    }
}

