/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import net.nemerosa.ontrack.extension.support.ConfigurationHealthIndicator;
import net.nemerosa.ontrack.extension.svn.client.SVNClient;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.support.SVNUtils;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.stereotype.Component;
import org.tmatesoft.svn.core.SVNURL;

@Component
public class SVNHealthIndicator
extends ConfigurationHealthIndicator<SVNConfiguration> {
    private final SVNService svnService;
    private final TransactionService transactionService;
    private final SVNClient svnClient;

    @Autowired
    public SVNHealthIndicator(ConfigurationService<SVNConfiguration> configurationService, SecurityService securityService, HealthAggregator healthAggregator, SVNService svnService, TransactionService transactionService, SVNClient svnClient) {
        super(configurationService, securityService, healthAggregator);
        this.svnService = svnService;
        this.transactionService = transactionService;
        this.svnClient = svnClient;
    }

    /*
     * Loose catch block
     */
    protected Health getHealth(SVNConfiguration config) {
        SVNRepository repository = this.svnService.getRepository(config.getName());
        Throwable throwable = null;
        try (Transaction ignored = this.transactionService.start();){
            SVNURL url = SVNUtils.toURL(repository.getConfiguration().getUrl());
            Health.Builder builder = Health.unknown();
            try {
                long repositoryRevision = this.svnClient.getRepositoryRevision(repository, url);
                Health health = builder.up().withDetail("revision", (Object)repositoryRevision).build();
                return health;
            }
            catch (Exception ex) {
                Health health;
                block17: {
                    block18: {
                        health = builder.down(ex).build();
                        if (ignored == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    ignored.close();
                }
                return health;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }
}

