/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.scm.support.TagPattern;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.support.AbstractTagBasedSvnRevisionLink;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.exceptions.JsonParsingException;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagNamePatternSvnRevisionLink
extends AbstractTagBasedSvnRevisionLink<TagPattern> {
    @Autowired
    public TagNamePatternSvnRevisionLink(SVNService svnService, StructureService structureService) {
        super(svnService, structureService);
    }

    @Override
    protected Optional<String> getBuildName(TagPattern data, String tagName) {
        if (data.isValidTagName(tagName)) {
            return data.getBuildNameFromTagName(tagName);
        }
        return Optional.empty();
    }

    @Override
    public String getId() {
        return "tagPattern";
    }

    @Override
    public String getName() {
        return "Tag pattern as name";
    }

    @Override
    public TagPattern clone(TagPattern data, Function<String, String> replacementFunction) {
        return data.clone(replacementFunction);
    }

    @Override
    public TagPattern parseData(JsonNode node) {
        try {
            return (TagPattern)ObjectMapperFactory.create().treeToValue((TreeNode)node, TagPattern.class);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException((Exception)((Object)e));
        }
    }

    @Override
    public JsonNode toJson(TagPattern data) {
        return ObjectMapperFactory.create().valueToTree((Object)data);
    }

    @Override
    public Form getForm() {
        return Form.create().with((Field)((Text)Text.of((String)"pattern").label("Tag pattern")).help("@file:extension/svn/buildRevisionLink/tagPattern.help.tpl.html"));
    }

    @Override
    public boolean isValidBuildName(TagPattern data, String name) {
        return data.isValidTagName(name);
    }

    @Override
    protected Optional<String> getTagName(TagPattern data, String buildName) {
        return data.getTagNameFromBuildName(buildName);
    }
}

