/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.support;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.support.NoConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RevisionSvnRevisionLink
implements BuildSvnRevisionLink<NoConfig> {
    private final StructureService structureService;

    @Autowired
    public RevisionSvnRevisionLink(StructureService structureService) {
        this.structureService = structureService;
    }

    @Override
    public String getId() {
        return "revision";
    }

    @Override
    public String getName() {
        return "Revision as name";
    }

    @Override
    public NoConfig clone(NoConfig data, Function<String, String> replacementFunction) {
        return data;
    }

    @Override
    public NoConfig parseData(JsonNode node) {
        return NoConfig.INSTANCE;
    }

    @Override
    public JsonNode toJson(NoConfig data) {
        return JsonUtils.object().end();
    }

    @Override
    public Form getForm() {
        return Form.create();
    }

    @Override
    public boolean isValidBuildName(NoConfig data, String name) {
        return StringUtils.isNumeric((CharSequence)name) && Long.parseLong(name, 10) > 0L;
    }

    @Override
    public OptionalLong getRevision(NoConfig data, Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        if (StringUtils.isNumeric((CharSequence)build.getName())) {
            return OptionalLong.of(Long.parseLong(build.getName(), 10));
        }
        return OptionalLong.empty();
    }

    @Override
    public String getBuildPath(NoConfig data, Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return branchConfigurationProperty.getCuredBranchPath() + "@" + build.getName();
    }

    @Override
    public Optional<Build> getEarliestBuild(NoConfig data, Branch branch, SVNLocation location, SVNLocation firstCopy, SVNBranchConfigurationProperty branchConfigurationProperty) {
        if (StringUtils.equals((CharSequence)branchConfigurationProperty.getCuredBranchPath(), (CharSequence)location.getPath())) {
            String buildName = String.valueOf(location.getRevision());
            return this.structureService.findBuildAfterUsingNumericForm(branch.getId(), buildName);
        }
        return Optional.empty();
    }
}

