/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.support.RevisionPattern;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.exceptions.JsonParsingException;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildSortDirection;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RevisionPatternSvnRevisionLink
implements BuildSvnRevisionLink<RevisionPattern> {
    private final StructureService structureService;

    @Autowired
    public RevisionPatternSvnRevisionLink(StructureService structureService) {
        this.structureService = structureService;
    }

    @Override
    public String getId() {
        return "revisionPattern";
    }

    @Override
    public String getName() {
        return "Build name contains a revision";
    }

    @Override
    public RevisionPattern clone(RevisionPattern data, Function<String, String> replacementFunction) {
        return data.clone(replacementFunction);
    }

    @Override
    public RevisionPattern parseData(JsonNode node) {
        try {
            return (RevisionPattern)ObjectMapperFactory.create().treeToValue((TreeNode)node, RevisionPattern.class);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException((Exception)((Object)e));
        }
    }

    @Override
    public JsonNode toJson(RevisionPattern data) {
        return ObjectMapperFactory.create().valueToTree((Object)data);
    }

    @Override
    public Form getForm() {
        return Form.create().with((Field)((Text)Text.of((String)"pattern").label("Revision pattern")).regex(".*\\{revision\\}.*").help("@file:extension/svn/buildRevisionLink/revisionPattern.help.tpl.html"));
    }

    @Override
    public boolean isValidBuildName(RevisionPattern data, String name) {
        return data.isValidBuildName(name);
    }

    @Override
    public OptionalLong getRevision(RevisionPattern data, Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return data.extractRevision(build.getName());
    }

    @Override
    public String getBuildPath(RevisionPattern data, Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return branchConfigurationProperty.getCuredBranchPath() + "@" + this.getRevision(data, build, branchConfigurationProperty).getAsLong();
    }

    @Override
    public Optional<Build> getEarliestBuild(RevisionPattern data, Branch branch, SVNLocation location, SVNLocation firstCopy, SVNBranchConfigurationProperty branchConfigurationProperty) {
        if (StringUtils.equals((CharSequence)branchConfigurationProperty.getCuredBranchPath(), (CharSequence)location.getPath())) {
            return this.structureService.findBuild(branch.getId(), build -> {
                OptionalLong oRevision = this.getRevision(data, (Build)build, branchConfigurationProperty);
                return oRevision.isPresent() && oRevision.getAsLong() >= location.getRevision();
            }, BuildSortDirection.FROM_OLDEST);
        }
        return Optional.empty();
    }
}

