/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.support;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.model.IndexableBuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;

public class ConfiguredBuildSvnRevisionLink<T> {
    private final BuildSvnRevisionLink<T> link;
    private final T data;

    public ConfiguredBuildSvnRevisionLink<T> clone(Function<String, String> replacementFunction) {
        return new ConfiguredBuildSvnRevisionLink<T>(this.link, this.link.clone(this.data, replacementFunction));
    }

    public ServiceConfiguration toServiceConfiguration() {
        return new ServiceConfiguration(this.link.getId(), this.link.toJson(this.data));
    }

    public boolean isValidBuildName(String name) {
        return this.link.isValidBuildName(this.data, name);
    }

    public OptionalLong getRevision(Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return this.link.getRevision(this.data, build, branchConfigurationProperty);
    }

    public String getBuildPath(Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return this.link.getBuildPath(this.data, build, branchConfigurationProperty);
    }

    public Optional<Build> getEarliestBuild(Branch branch, SVNLocation location, SVNLocation firstCopy, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return this.link.getEarliestBuild(this.data, branch, location, firstCopy, branchConfigurationProperty);
    }

    public Optional<String> getBuildNameFromTagName(String tagName) {
        if (this.link instanceof IndexableBuildSvnRevisionLink) {
            return ((IndexableBuildSvnRevisionLink)this.link).getBuildNameFromTagName(this.data, tagName);
        }
        throw new UnsupportedOperationException("getBuildNameFromPath is not supported for non indexable links");
    }

    @ConstructorProperties(value={"link", "data"})
    public ConfiguredBuildSvnRevisionLink(BuildSvnRevisionLink<T> link, T data) {
        this.link = link;
        this.data = data;
    }

    public BuildSvnRevisionLink<T> getLink() {
        return this.link;
    }

    public T getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfiguredBuildSvnRevisionLink)) {
            return false;
        }
        ConfiguredBuildSvnRevisionLink other = (ConfiguredBuildSvnRevisionLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BuildSvnRevisionLink<T> this$link = this.getLink();
        BuildSvnRevisionLink<T> other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfiguredBuildSvnRevisionLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuildSvnRevisionLink<T> $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ConfiguredBuildSvnRevisionLink(link=" + this.getLink() + ", data=" + this.getData() + ")";
    }
}

