/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nemerosa.ontrack.client.JsonClientMappingException;
import net.nemerosa.ontrack.extension.scm.support.TagPattern;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.support.ConfiguredBuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.support.RevisionSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.support.TagNamePatternSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.support.TagNameSvnRevisionLink;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;
import net.nemerosa.ontrack.model.support.DBMigrationAction;
import net.nemerosa.ontrack.model.support.NoConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildSvnRevisionLinkMigrationAction
implements DBMigrationAction {
    public static final String BUILD_PLACEHOLDER_PATTERN = "\\{(.+)\\}";
    private final Logger logger = LoggerFactory.getLogger(BuildSvnRevisionLinkMigrationAction.class);
    private final ObjectMapper objectMapper = ObjectMapperFactory.create();
    private final RevisionSvnRevisionLink revisionLink;
    private final TagNamePatternSvnRevisionLink tagPatternLink;
    private final TagNameSvnRevisionLink tagLink;

    @Autowired
    public BuildSvnRevisionLinkMigrationAction(RevisionSvnRevisionLink revisionLink, TagNamePatternSvnRevisionLink tagPatternLink, TagNameSvnRevisionLink tagLink) {
        this.revisionLink = revisionLink;
        this.tagPatternLink = tagPatternLink;
        this.tagLink = tagLink;
    }

    public int getPatch() {
        return 23;
    }

    public void migrate(Connection connection) throws Exception {
        this.migrateSvnConfigurations(connection);
        this.migrateSvnBranchConfigurations(connection);
    }

    private void migrateSvnConfigurations(Connection connection) throws SQLException, IOException {
        try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM CONFIGURATIONS WHERE TYPE = ?", 1003, 1008);){
            ps.setString(1, SVNConfiguration.class.getName());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String json = rs.getString("CONTENT");
                    ObjectNode node = (ObjectNode)this.objectMapper.readTree(json);
                    this.migrateSvnConfiguration(node);
                    rs.updateString("CONTENT", this.objectMapper.writeValueAsString((Object)node));
                    rs.updateRow();
                }
            }
        }
    }

    private void migrateSvnBranchConfigurations(Connection connection) throws SQLException, IOException {
        try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM PROPERTIES WHERE TYPE = ?", 1003, 1008);){
            ps.setString(1, SVNBranchConfigurationPropertyType.class.getName());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String json = rs.getString("JSON");
                    ObjectNode node = (ObjectNode)this.objectMapper.readTree(json);
                    this.migrateSvnBranchConfiguration(node);
                    rs.updateString("JSON", this.objectMapper.writeValueAsString((Object)node));
                    rs.updateRow();
                }
            }
        }
    }

    protected void migrateSvnConfiguration(ObjectNode node) {
        node.remove("branchPattern");
        node.remove("tagPattern");
    }

    protected void migrateSvnBranchConfiguration(ObjectNode node) {
        String branchPath = node.get("branchPath").asText();
        String buildPath = node.get("buildPath").asText();
        node.remove("buildPath");
        ConfiguredBuildSvnRevisionLink<?> configuredBuildSvnRevisionLink = this.toBuildSvnRevisionLinkConfiguration(buildPath);
        ServiceConfiguration serviceConfiguration = configuredBuildSvnRevisionLink.toServiceConfiguration();
        node.put("buildRevisionLink", (JsonNode)((ObjectNode)this.objectMapper.valueToTree((Object)serviceConfiguration)));
        try {
            this.logger.info("SVN branch config for {} with build expression {} has been converted to {}", new Object[]{branchPath, buildPath, this.objectMapper.writeValueAsString((Object)serviceConfiguration)});
        }
        catch (IOException ex) {
            throw new JsonClientMappingException(ex);
        }
    }

    protected ConfiguredBuildSvnRevisionLink<?> toBuildSvnRevisionLinkConfiguration(String buildPath) {
        if (buildPath.endsWith("@{build}")) {
            return new ConfiguredBuildSvnRevisionLink<NoConfig>(this.revisionLink, NoConfig.INSTANCE);
        }
        Pattern pattern = Pattern.compile(BUILD_PLACEHOLDER_PATTERN);
        Matcher matcher = pattern.matcher(buildPath);
        if (matcher.find()) {
            String expression = matcher.group(1);
            if ("build".equals(expression)) {
                return new ConfiguredBuildSvnRevisionLink<NoConfig>(this.tagLink, NoConfig.INSTANCE);
            }
            if (StringUtils.startsWith((CharSequence)expression, (CharSequence)"build:")) {
                String buildExpression = StringUtils.substringAfter((String)expression, (String)"build:");
                return new ConfiguredBuildSvnRevisionLink<TagPattern>(this.tagPatternLink, new TagPattern(buildExpression));
            }
        }
        return new ConfiguredBuildSvnRevisionLink<NoConfig>(this.tagLink, NoConfig.INSTANCE);
    }

    public String getDisplayName() {
        return "Migration of SVN branch configurations to the use of revision links";
    }
}

