/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.nemerosa.ontrack.extension.svn.SubversionConfProperties;
import net.nemerosa.ontrack.extension.svn.db.SVNEventDao;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.db.TCopyEvent;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLinkService;
import net.nemerosa.ontrack.extension.svn.model.IndexableBuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.SVNSyncInfoStatus;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNSyncProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNSyncPropertyType;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.service.SVNSyncService;
import net.nemerosa.ontrack.extension.svn.support.ConfiguredBuildSvnRevisionLink;
import net.nemerosa.ontrack.job.Job;
import net.nemerosa.ontrack.job.JobKey;
import net.nemerosa.ontrack.job.JobRegistration;
import net.nemerosa.ontrack.job.JobRun;
import net.nemerosa.ontrack.job.JobRunListener;
import net.nemerosa.ontrack.job.JobScheduler;
import net.nemerosa.ontrack.job.JobType;
import net.nemerosa.ontrack.job.orchestrator.JobOrchestratorSupplier;
import net.nemerosa.ontrack.model.security.BuildCreate;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.support.AbstractBranchJob;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SVNSyncServiceImpl
implements SVNSyncService,
JobOrchestratorSupplier {
    private static final JobType SVN_BUILD_SYNC_JOB = SVNService.SVN_JOB_CATEGORY.getType("svn-build-sync");
    private final Logger logger = LoggerFactory.getLogger(SVNSyncService.class);
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final SecurityService securityService;
    private final SVNService svnService;
    private final SVNEventDao eventDao;
    private final TransactionTemplate transactionTemplate;
    private final JobScheduler jobScheduler;
    private final BuildSvnRevisionLinkService buildSvnRevisionLinkService;
    private final SubversionConfProperties subversionConfProperties;

    @Autowired
    public SVNSyncServiceImpl(StructureService structureService, PropertyService propertyService, SecurityService securityService, SVNService svnService, SVNEventDao eventDao, PlatformTransactionManager transactionManager, JobScheduler jobScheduler, BuildSvnRevisionLinkService buildSvnRevisionLinkService, SubversionConfProperties subversionConfProperties) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.securityService = securityService;
        this.svnService = svnService;
        this.eventDao = eventDao;
        this.jobScheduler = jobScheduler;
        this.buildSvnRevisionLinkService = buildSvnRevisionLinkService;
        this.subversionConfProperties = subversionConfProperties;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    @Override
    public SVNSyncInfoStatus launchSync(ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        this.securityService.checkProjectFunction(branch.projectId(), BuildCreate.class);
        Property syncProperty = this.propertyService.getProperty((ProjectEntity)branch, SVNSyncPropertyType.class);
        if (syncProperty.isEmpty()) {
            return SVNSyncInfoStatus.of(branchId).withMessage("The synchronisation has not been configured for this branch.");
        }
        Property projectConfigurationProperty = this.propertyService.getProperty((ProjectEntity)branch.getProject(), SVNProjectConfigurationPropertyType.class);
        if (projectConfigurationProperty.isEmpty()) {
            return SVNSyncInfoStatus.of(branchId).withMessage("SVN has not been configured for this branch's project.");
        }
        Property branchConfigurationProperty = this.propertyService.getProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class);
        if (branchConfigurationProperty.isEmpty()) {
            return SVNSyncInfoStatus.of(branchId).withMessage("SVN has not been configured for this branch.");
        }
        ConfiguredBuildSvnRevisionLink revisionLink = this.buildSvnRevisionLinkService.getConfiguredBuildSvnRevisionLink(((SVNBranchConfigurationProperty)branchConfigurationProperty.getValue()).getBuildRevisionLink());
        if (!(revisionLink instanceof IndexableBuildSvnRevisionLink)) {
            return SVNSyncInfoStatus.of(branchId).withMessage("The build path for the branch is not correctly configured.");
        }
        this.jobScheduler.fireImmediately(this.getSvnBuildSyncJobKey(branch));
        return SVNSyncInfoStatus.of(branchId);
    }

    protected void sync(Branch branch, JobRunListener runListener) {
        AtomicInteger createdBuilds = new AtomicInteger();
        SVNSyncProperty syncProperty = (SVNSyncProperty)this.propertyService.getProperty((ProjectEntity)branch, SVNSyncPropertyType.class).getValue();
        SVNProjectConfigurationProperty projectConfigurationProperty = (SVNProjectConfigurationProperty)this.propertyService.getProperty((ProjectEntity)branch.getProject(), SVNProjectConfigurationPropertyType.class).getValue();
        SVNBranchConfigurationProperty branchConfigurationProperty = (SVNBranchConfigurationProperty)this.propertyService.getProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class).getValue();
        SVNRepository repository = this.svnService.getRepository(projectConfigurationProperty.getConfiguration().getName());
        ConfiguredBuildSvnRevisionLink revisionLink = this.buildSvnRevisionLinkService.getConfiguredBuildSvnRevisionLink(branchConfigurationProperty.getBuildRevisionLink());
        this.svnService.getBasePath(repository, branchConfigurationProperty.getCuredBranchPath()).ifPresent(basePath -> {
            String tagsPath = basePath + "/tags";
            List<TCopyEvent> copies = this.eventDao.findCopies(repository.getId(), branchConfigurationProperty.getCuredBranchPath(), tagsPath, copyEvent -> this.getBuildNameFromPath(tagsPath, revisionLink, copyEvent.copyToLocation()).isPresent());
            for (TCopyEvent copy : copies) {
                Optional build = (Optional)this.transactionTemplate.execute(status -> this.createBuild(tagsPath, syncProperty, branch, copy, revisionLink, repository));
                if (!build.isPresent()) continue;
                int count = createdBuilds.incrementAndGet();
                runListener.message("Running build synchronisation from SVN for branch %s/%s: %d build(s) created", new Object[]{branch.getProject().getName(), branch.getName(), count});
            }
        });
    }

    private Optional<String> getBuildNameFromPath(String tagsPath, ConfiguredBuildSvnRevisionLink<?> revisionLink, SVNLocation location) {
        String path = location.getPath();
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)tagsPath)) {
            String tagName = StringUtils.strip((String)StringUtils.substringAfter((String)path, (String)tagsPath), (String)"/");
            return revisionLink.getBuildNameFromTagName(tagName);
        }
        return Optional.empty();
    }

    private Optional<Build> createBuild(String tagsPath, SVNSyncProperty syncProperty, Branch branch, TCopyEvent copy, ConfiguredBuildSvnRevisionLink<?> revisionLink, SVNRepository repository) {
        return this.getBuildNameFromPath(tagsPath, revisionLink, copy.copyToLocation()).flatMap(buildName -> {
            Optional build = this.structureService.findBuildByName(branch.getProject().getName(), branch.getName(), buildName);
            if (!build.isPresent()) {
                this.logger.debug("[svn-sync] Build {} does not exist - creating.", buildName);
                return Optional.of(this.doCreateBuild(branch, copy, (String)buildName, repository));
            }
            if (syncProperty.isOverride()) {
                this.logger.debug("[svn-sync] Build {} already exists - overriding.", buildName);
                this.structureService.deleteBuild(((Build)build.get()).getId());
                return Optional.of(this.doCreateBuild(branch, copy, (String)buildName, repository));
            }
            this.logger.debug("[svn-sync] Build {} already exists - not overriding.", buildName);
            return Optional.empty();
        });
    }

    private Build doCreateBuild(Branch branch, TCopyEvent copy, String buildName, SVNRepository repository) {
        SVNRevisionInfo revisionInfo = this.svnService.getRevisionInfo(repository, copy.getRevision());
        LocalDateTime revisionTime = revisionInfo.getDateTime();
        return this.structureService.newBuild(Build.of((Branch)branch, (NameDescription)new NameDescription(buildName, String.format("Build created by SVN synchronisation from tag %s", copy.getCopyToPath())), (Signature)this.securityService.getCurrentSignature().withTime(revisionTime)));
    }

    public Stream<JobRegistration> collectJobRegistrations() {
        if (this.subversionConfProperties.isBuildSyncDisabled()) {
            return Stream.empty();
        }
        return (Stream)this.securityService.asAdmin(() -> this.getSVNConfiguredBranches().filter(branch -> this.propertyService.getProperty((ProjectEntity)branch, SVNSyncPropertyType.class).option().isPresent()).map(this::getSVNBuildSyncJobRegistration));
    }

    private JobRegistration getSVNBuildSyncJobRegistration(Branch branch) {
        Property svnSync = this.propertyService.getProperty((ProjectEntity)branch, SVNSyncPropertyType.class);
        if (svnSync.isEmpty()) {
            throw new IllegalStateException("No SVN build sync is set");
        }
        return JobRegistration.of((Job)this.createJob(branch)).everyMinutes((long)((SVNSyncProperty)svnSync.getValue()).getInterval());
    }

    protected Job createJob(final Branch branch) {
        return new AbstractBranchJob(this.structureService, branch){

            public JobKey getKey() {
                return SVNSyncServiceImpl.this.getSvnBuildSyncJobKey(branch);
            }

            public JobRun getTask() {
                return runListener -> SVNSyncServiceImpl.this.sync(branch, runListener);
            }

            public String getDescription() {
                return String.format("Synchronisation of builds with SVN for branch %s/%s", branch.getProject().getName(), branch.getName());
            }

            public boolean isValid() {
                return super.isValid() && SVNSyncServiceImpl.this.propertyService.hasProperty((ProjectEntity)branch, SVNSyncPropertyType.class) && SVNSyncServiceImpl.this.svnService.getSVNRepository(branch).isPresent();
            }
        };
    }

    protected JobKey getSvnBuildSyncJobKey(Branch branch) {
        return SVN_BUILD_SYNC_JOB.getKey(String.valueOf(branch.getId()));
    }

    protected Stream<Branch> getSVNConfiguredBranches() {
        return this.structureService.getProjectList().stream().filter(project -> this.propertyService.hasProperty((ProjectEntity)project, SVNProjectConfigurationPropertyType.class)).flatMap(project -> this.structureService.getBranchesForProject(project.getId()).stream()).filter(branch -> this.propertyService.hasProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class));
    }
}

