/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.service;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.nemerosa.ontrack.extension.scm.service.SCMService;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.db.TCopyEvent;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevision;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.model.SVNRepositoryIssue;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionPaths;
import net.nemerosa.ontrack.extension.svn.model.SVNSyncInfo;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationProperty;
import net.nemerosa.ontrack.job.JobCategory;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ID;

public interface SVNService
extends SCMService {
    public static final JobCategory SVN_JOB_CATEGORY = JobCategory.of((String)"svn").withName("Subversion");

    public SVNRevisionInfo getRevisionInfo(SVNRepository var1, long var2);

    public SVNRevisionPaths getRevisionPaths(SVNRepository var1, long var2);

    public List<Long> getRevisionsForIssueKey(SVNRepository var1, String var2);

    public SVNRepository getRepository(String var1);

    public Optional<SVNRepositoryIssue> searchIssues(SVNRepository var1, String var2);

    public SVNChangeLogRevision createChangeLogRevision(SVNRepository var1, SVNRevisionInfo var2);

    public void forEachConfiguredBranch(Predicate<SVNProjectConfigurationProperty> var1, BiConsumer<Branch, SVNBranchConfigurationProperty> var2);

    public SVNSyncInfo getSyncInfo(ID var1);

    public Optional<SVNRepository> getSVNRepository(Branch var1);

    public SVNRepository getRequiredSVNRepository(Branch var1);

    public List<String> getBranches(Branch var1);

    public TCopyEvent getLastCopyEvent(int var1, String var2, long var3);

    public Optional<String> getTagPathForTagName(SVNRepository var1, String var2, String var3);

    public Optional<String> getBasePath(SVNRepository var1, String var2);

    public SVNLocation getFirstCopyAfter(SVNRepository var1, SVNLocation var2);
}

