/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.scm.model.SCMIssueCommitBranchInfo;
import net.nemerosa.ontrack.extension.scm.service.SCMUtilsService;
import net.nemerosa.ontrack.extension.svn.db.SVNIssueRevisionDao;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.db.SVNRevisionDao;
import net.nemerosa.ontrack.extension.svn.db.TRevision;
import net.nemerosa.ontrack.extension.svn.model.BranchRevision;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLinkService;
import net.nemerosa.ontrack.extension.svn.model.OntrackSVNIssueInfo;
import net.nemerosa.ontrack.extension.svn.model.OntrackSVNIssueRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.OntrackSVNRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevision;
import net.nemerosa.ontrack.extension.svn.model.SVNInfoService;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionInfo;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.support.ConfiguredBuildSvnRevisionLink;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchStatusView;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SVNInfoServiceImpl
implements SVNInfoService {
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final SVNService svnService;
    private final BuildSvnRevisionLinkService buildSvnRevisionLinkService;
    private final SVNIssueRevisionDao issueRevisionDao;
    private final SVNRevisionDao revisionDao;
    private final SCMUtilsService scmService;

    @Autowired
    public SVNInfoServiceImpl(StructureService structureService, PropertyService propertyService, SVNService svnService, BuildSvnRevisionLinkService buildSvnRevisionLinkService, SVNIssueRevisionDao issueRevisionDao, SVNRevisionDao revisionDao, SCMUtilsService scmService) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.svnService = svnService;
        this.buildSvnRevisionLinkService = buildSvnRevisionLinkService;
        this.issueRevisionDao = issueRevisionDao;
        this.revisionDao = revisionDao;
        this.scmService = scmService;
    }

    @Override
    public OntrackSVNIssueInfo getIssueInfo(String configurationName, String issueKey) {
        SVNRepository repository = this.svnService.getRepository(configurationName);
        ConfiguredIssueService configuredIssueService = repository.getConfiguredIssueService();
        if (configuredIssueService == null) {
            return OntrackSVNIssueInfo.empty(repository.getConfiguration());
        }
        Issue issue = configuredIssueService.getIssue(issueKey);
        HashMap branchRevisions = new HashMap();
        this.svnService.forEachConfiguredBranch(config -> Objects.equals(configurationName, config.getConfiguration().getName()), (branch, branchConfig) -> {
            String branchPath = branchConfig.getCuredBranchPath();
            Collection linkedIssues = configuredIssueService.getLinkedIssues(branch.getProject(), issue).stream().map(Issue::getKey).collect(Collectors.toList());
            this.issueRevisionDao.findLastRevisionByIssuesAndBranch(repository.getId(), linkedIssues, branchPath).ifPresent(revision -> branchRevisions.put(branchPath, new BranchRevision(branchPath, revision, false)));
        });
        while (!BranchRevision.areComplete(branchRevisions.values())) {
            Collection incompleteRevisions = branchRevisions.values().stream().filter(br -> !br.isComplete()).collect(Collectors.toList());
            incompleteRevisions.forEach(br -> {
                List<Long> merges = this.revisionDao.getMergesForRevision(repository.getId(), br.getRevision());
                branchRevisions.put(br.getPath(), br.complete());
                List<TRevision> revisions = merges.stream().map(r -> this.revisionDao.get(repository.getId(), (long)r)).collect(Collectors.toList());
                revisions.forEach(t -> {
                    String branch = t.getBranch();
                    BranchRevision existingBranchRevision = (BranchRevision)branchRevisions.get(branch);
                    if (existingBranchRevision == null || t.getRevision() > existingBranchRevision.getRevision()) {
                        branchRevisions.put(branch, new BranchRevision(branch, t.getRevision(), true));
                    }
                });
            });
        }
        ArrayList<OntrackSVNIssueRevisionInfo> issueRevisionInfos = new ArrayList<OntrackSVNIssueRevisionInfo>();
        branchRevisions.values().forEach(br -> {
            SVNRevisionInfo basicInfo = this.svnService.getRevisionInfo(repository, br.getRevision());
            SVNChangeLogRevision changeLogRevision = this.svnService.createChangeLogRevision(repository, basicInfo);
            OntrackSVNIssueRevisionInfo issueRevisionInfo = OntrackSVNIssueRevisionInfo.of(changeLogRevision);
            AtomicReference rBranch = new AtomicReference();
            this.svnService.forEachConfiguredBranch(config -> Objects.equals(configurationName, config.getConfiguration().getName()), (candidate, branchConfig) -> {
                String branchPath = branchConfig.getCuredBranchPath();
                if (Objects.equals(br.getPath(), branchPath)) {
                    rBranch.set(candidate);
                }
            });
            Branch branch = (Branch)rBranch.get();
            if (branch != null) {
                SCMIssueCommitBranchInfo branchInfo = SCMIssueCommitBranchInfo.of((Branch)branch);
                SVNLocation firstCopy = this.svnService.getFirstCopyAfter(repository, basicInfo.toLocation());
                Optional<Build> buildAfterCommit = this.lookupBuild(basicInfo.toLocation(), firstCopy, branch);
                branchInfo = this.scmService.getBranchInfo(buildAfterCommit, branchInfo);
                issueRevisionInfo.add(branchInfo);
            }
            issueRevisionInfos.add(issueRevisionInfo);
        });
        List<SVNChangeLogRevision> revisions = this.svnService.getRevisionsForIssueKey(repository, issueKey).stream().map(revision -> this.svnService.createChangeLogRevision(repository, this.svnService.getRevisionInfo(repository, (long)revision))).collect(Collectors.toList());
        return new OntrackSVNIssueInfo(repository.getConfiguration(), repository.getConfiguredIssueService().getIssueServiceConfigurationRepresentation(), issue, issueRevisionInfos, revisions);
    }

    @Override
    public OntrackSVNRevisionInfo getOntrackRevisionInfo(SVNRepository repository, long revision) {
        SVNRevisionInfo basicInfo = this.svnService.getRevisionInfo(repository, revision);
        SVNChangeLogRevision changeLogRevision = this.svnService.createChangeLogRevision(repository, basicInfo);
        SVNLocation firstCopy = this.svnService.getFirstCopyAfter(repository, basicInfo.toLocation());
        ArrayList<BuildView> buildViews = new ArrayList<BuildView>();
        ArrayList<BranchStatusView> branchStatusViews = new ArrayList<BranchStatusView>();
        for (Project project : this.structureService.getProjectList()) {
            Property projectSvnConfig = this.propertyService.getProperty((ProjectEntity)project, SVNProjectConfigurationPropertyType.class);
            if (projectSvnConfig.isEmpty() || !repository.getConfiguration().getName().equals(((SVNProjectConfigurationProperty)projectSvnConfig.getValue()).getConfiguration().getName())) continue;
            for (Branch branch : this.structureService.getBranchesForProject(project.getId())) {
                Optional<Build> build;
                if (branch.getType() == BranchType.TEMPLATE_DEFINITION || !this.propertyService.hasProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class) || !(build = this.lookupBuild(basicInfo.toLocation(), firstCopy, branch)).isPresent()) continue;
                BuildView buildView = this.structureService.getBuildView(build.get(), true);
                buildViews.add(buildView);
                branchStatusViews.add(this.structureService.getEarliestPromotionsAfterBuild(build.get()));
            }
        }
        return new OntrackSVNRevisionInfo(repository.getConfiguration(), changeLogRevision, buildViews, branchStatusViews);
    }

    protected Optional<Build> lookupBuild(SVNLocation location, SVNLocation firstCopy, Branch branch) {
        Property configurationProperty = this.propertyService.getProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class);
        if (configurationProperty.isEmpty()) {
            return Optional.empty();
        }
        ConfiguredBuildSvnRevisionLink revisionLink = this.buildSvnRevisionLinkService.getConfiguredBuildSvnRevisionLink(((SVNBranchConfigurationProperty)configurationProperty.getValue()).getBuildRevisionLink());
        return revisionLink.getEarliestBuild(branch, location, firstCopy, (SVNBranchConfigurationProperty)configurationProperty.getValue());
    }
}

