/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.api.model.BuildDiffRequest;
import net.nemerosa.ontrack.extension.issues.export.ExportFormat;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.extension.scm.model.SCMBuildView;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogIssue;
import net.nemerosa.ontrack.extension.scm.service.AbstractSCMChangeLogService;
import net.nemerosa.ontrack.extension.svn.client.SVNClient;
import net.nemerosa.ontrack.extension.svn.db.SVNIssueRevisionDao;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLinkService;
import net.nemerosa.ontrack.extension.svn.model.MissingSVNBranchConfigurationException;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLog;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogDifferentBranchException;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogFile;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogFileChange;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogFiles;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogIssue;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogIssues;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogReference;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevision;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevisions;
import net.nemerosa.ontrack.extension.svn.model.SVNHistory;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionPath;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionPaths;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.service.SVNChangeLogService;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.service.SVNServiceUtils;
import net.nemerosa.ontrack.extension.svn.support.ConfiguredBuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.support.SVNLogEntryCollector;
import net.nemerosa.ontrack.extension.svn.support.SVNUtils;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;

@Service
public class SVNChangeLogServiceImpl
extends AbstractSCMChangeLogService
implements SVNChangeLogService {
    private final BuildSvnRevisionLinkService buildSvnRevisionLinkService;
    private final SVNIssueRevisionDao issueRevisionDao;
    private final SVNService svnService;
    private final SVNClient svnClient;
    private final TransactionService transactionService;

    @Autowired
    public SVNChangeLogServiceImpl(StructureService structureService, PropertyService propertyService, BuildSvnRevisionLinkService buildSvnRevisionLinkService, SVNIssueRevisionDao issueRevisionDao, SVNService svnService, SVNClient svnClient, TransactionService transactionService) {
        super(structureService, propertyService);
        this.buildSvnRevisionLinkService = buildSvnRevisionLinkService;
        this.issueRevisionDao = issueRevisionDao;
        this.svnService = svnService;
        this.svnClient = svnClient;
        this.transactionService = transactionService;
    }

    @Override
    @Transactional
    public SVNChangeLog changeLog(BuildDiffRequest request) {
        try (Transaction ignored = this.transactionService.start();){
            Build buildFrom = this.structureService.getBuild(request.getFrom());
            Build buildTo = this.structureService.getBuild(request.getTo());
            if (buildFrom.id() > buildTo.id()) {
                Build t = buildFrom;
                buildFrom = buildTo;
                buildTo = t;
            }
            Branch branchFrom = buildFrom.getBranch();
            Branch branchTo = buildTo.getBranch();
            if (branchFrom.id() != branchTo.id()) {
                throw new SVNChangeLogDifferentBranchException();
            }
            SVNRepository svnRepository = this.getSVNRepository(branchFrom);
            SVNChangeLog sVNChangeLog = new SVNChangeLog(UUID.randomUUID().toString(), branchFrom.getProject(), svnRepository, this.getSCMBuildView(svnRepository, buildFrom.getId()), this.getSCMBuildView(svnRepository, buildTo.getId()));
            return sVNChangeLog;
        }
    }

    @Override
    @Transactional
    public SVNChangeLogRevisions getChangeLogRevisions(SVNChangeLog changeLog) {
        Collection<SVNChangeLogReference> references = changeLog.getChangeLogReferences();
        if (references.isEmpty()) {
            return SVNChangeLogRevisions.none();
        }
        try (Transaction ignored = this.transactionService.start();){
            ArrayList<SVNChangeLogRevision> revisions = new ArrayList<SVNChangeLogRevision>();
            for (SVNChangeLogReference reference : references) {
                if (reference.isNone()) continue;
                SVNRepository repository = changeLog.getRepository();
                SVNLogEntryCollector logEntryCollector = new SVNLogEntryCollector();
                this.svnClient.log(repository, SVNUtils.toURL(repository.getUrl(reference.getPath())), SVNRevision.create((long)reference.getEnd()), SVNRevision.create((long)(reference.getStart() + 1L)), SVNRevision.create((long)reference.getEnd()), true, false, 0L, true, logEntryCollector);
                int level = 0;
                for (SVNLogEntry svnEntry : logEntryCollector.getEntries()) {
                    long revision = svnEntry.getRevision();
                    if (SVNRevision.isValidRevisionNumber((long)revision)) {
                        SVNChangeLogRevision entry = this.createChangeLogRevision(repository, reference.getPath(), level, svnEntry);
                        revisions.add(entry);
                        if (!svnEntry.hasChildren()) continue;
                        ++level;
                        continue;
                    }
                    --level;
                }
            }
            Collections.sort(revisions, (o1, o2) -> Long.compare(o2.getRevision(), o1.getRevision()));
            SVNChangeLogRevisions sVNChangeLogRevisions = new SVNChangeLogRevisions(revisions);
            return sVNChangeLogRevisions;
        }
    }

    @Override
    @Transactional
    public SVNChangeLogIssues getChangeLogIssues(SVNChangeLog changeLog) {
        if (changeLog.getRevisions() == null) {
            changeLog.withRevisions(this.getChangeLogRevisions(changeLog));
        }
        try (Transaction ignored = this.transactionService.start();){
            SVNRepository repository = changeLog.getRepository();
            TreeMap<String, SVNChangeLogIssue> issues = new TreeMap<String, SVNChangeLogIssue>();
            for (SVNChangeLogRevision changeLogRevision : changeLog.getRevisions().getList()) {
                long revision = changeLogRevision.getRevision();
                this.collectIssuesForRevision(repository, issues, revision);
            }
            ArrayList<SVNChangeLogIssue> issuesList = new ArrayList<SVNChangeLogIssue>(issues.values());
            this.validateIssues(issuesList, changeLog);
            IssueServiceConfigurationRepresentation issueServiceConfiguration = null;
            String allIssuesLink = "";
            ConfiguredIssueService configuredIssueService = repository.getConfiguredIssueService();
            if (configuredIssueService != null) {
                issueServiceConfiguration = configuredIssueService.getIssueServiceConfigurationRepresentation();
                allIssuesLink = configuredIssueService.getLinkForAllIssues(issuesList.stream().map(SCMChangeLogIssue::getIssue).collect(Collectors.toList()));
            }
            SVNChangeLogIssues sVNChangeLogIssues = new SVNChangeLogIssues(allIssuesLink, issueServiceConfiguration, issuesList);
            return sVNChangeLogIssues;
        }
    }

    @Override
    @Transactional
    public SVNChangeLogFiles getChangeLogFiles(SVNChangeLog changeLog) {
        if (changeLog.getRevisions() == null) {
            changeLog.withRevisions(this.getChangeLogRevisions(changeLog));
        }
        try (Transaction ignored = this.transactionService.start();){
            TreeMap files = new TreeMap();
            changeLog.getRevisions().getList().stream().filter(changeLogRevision -> changeLogRevision.getLevel() == 0).forEach(changeLogRevision -> {
                long revision = changeLogRevision.getRevision();
                this.collectFilesForRevision(changeLog.getRepository(), files, revision);
            });
            SVNChangeLogFiles sVNChangeLogFiles = new SVNChangeLogFiles(new ArrayList<SVNChangeLogFile>(files.values()));
            return sVNChangeLogFiles;
        }
    }

    private void collectFilesForRevision(SVNRepository repository, Map<String, SVNChangeLogFile> files, long revision) {
        SVNRevisionPaths revisionPaths = this.svnService.getRevisionPaths(repository, revision);
        for (SVNRevisionPath revisionPath : revisionPaths.getPaths()) {
            String path = revisionPath.getPath();
            SVNChangeLogFile changeLogFile = files.get(path);
            if (changeLogFile == null) {
                changeLogFile = new SVNChangeLogFile(path, repository.getPathBrowsingURL(path));
                files.put(path, changeLogFile);
            }
            SVNChangeLogFileChange change = new SVNChangeLogFileChange(revisionPaths.getInfo(), revisionPath.getChangeType(), repository.getFileChangeBrowsingURL(path, revisionPaths.getInfo().getRevision()));
            changeLogFile.addChange(change);
        }
    }

    private void collectIssuesForRevision(SVNRepository repository, Map<String, SVNChangeLogIssue> issues, long revision) {
        List<String> issueKeys = this.issueRevisionDao.findIssuesByRevision(repository.getId(), revision);
        for (String issueKey : issueKeys) {
            SVNChangeLogIssue changeLogIssue = issues.get(issueKey);
            if (changeLogIssue == null) {
                changeLogIssue = this.getChangeLogIssue(repository, issueKey);
            }
            if (changeLogIssue == null) continue;
            SVNRevisionInfo issueRevision = this.svnService.getRevisionInfo(repository, revision);
            changeLogIssue = changeLogIssue.addRevision(issueRevision);
            issues.put(issueKey, changeLogIssue);
        }
    }

    private SVNChangeLogIssue getChangeLogIssue(SVNRepository repository, String issueKey) {
        ConfiguredIssueService configuredIssueService = repository.getConfiguredIssueService();
        if (configuredIssueService != null) {
            Issue issue = configuredIssueService.getIssue(issueKey);
            if (issue == null || StringUtils.isBlank((CharSequence)issue.getKey())) {
                return null;
            }
            return new SVNChangeLogIssue(issue);
        }
        return null;
    }

    private SVNChangeLogRevision createChangeLogRevision(SVNRepository repository, String path, int level, SVNLogEntry svnEntry) {
        return SVNServiceUtils.createChangeLogRevision(repository, path, level, svnEntry.getRevision(), svnEntry.getMessage(), svnEntry.getAuthor(), Time.from((Date)svnEntry.getDate(), null));
    }

    protected SCMBuildView<SVNHistory> getSCMBuildView(SVNRepository svnRepository, ID buildId) {
        BuildView buildView = this.getBuildView(buildId);
        SVNHistory history = this.getBuildSVNHistory(svnRepository, buildView.getBuild());
        return new SCMBuildView(buildView, (Object)history);
    }

    @Override
    public OptionalLong getBuildRevision(Build build) {
        Property branchConfigurationProperty = this.propertyService.getProperty((ProjectEntity)build.getBranch(), SVNBranchConfigurationPropertyType.class);
        Property projectConfigurationProperty = this.propertyService.getProperty((ProjectEntity)build.getBranch().getProject(), SVNProjectConfigurationPropertyType.class);
        if (branchConfigurationProperty.isEmpty() || projectConfigurationProperty.isEmpty()) {
            return OptionalLong.empty();
        }
        ConfiguredBuildSvnRevisionLink revisionLink = this.buildSvnRevisionLinkService.getConfiguredBuildSvnRevisionLink(((SVNBranchConfigurationProperty)branchConfigurationProperty.getValue()).getBuildRevisionLink());
        return revisionLink.getRevision(build, (SVNBranchConfigurationProperty)branchConfigurationProperty.getValue());
    }

    @Override
    public String getDiff(SVNRepository repository, SVNChangeLogFile changeLogFile) {
        try (Transaction ignored = this.transactionService.start();){
            String string = this.svnClient.getDiff(repository, changeLogFile.getPath(), changeLogFile.getChanges().stream().map(change -> change.getRevisionInfo().getRevision()).collect(Collectors.toList()));
            return string;
        }
    }

    @Override
    public SVNHistory getBuildSVNHistory(SVNRepository svnRepository, Build build) {
        String svnBuildPath = this.getSVNBuildPath(build);
        return this.svnClient.getHistory(svnRepository, svnBuildPath);
    }

    @Override
    public Collection<ExportFormat> changeLogExportFormats(ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        SVNRepository svnRepository = this.getSVNRepository(branch);
        ConfiguredIssueService configuredIssueService = svnRepository.getConfiguredIssueService();
        if (configuredIssueService != null) {
            return configuredIssueService.getIssueServiceExtension().exportFormats(configuredIssueService.getIssueServiceConfiguration());
        }
        return Collections.emptyList();
    }

    protected String getSVNBuildPath(Build build) {
        Property branchConfiguration = this.propertyService.getProperty((ProjectEntity)build.getBranch(), SVNBranchConfigurationPropertyType.class);
        if (branchConfiguration.isEmpty()) {
            throw new MissingSVNBranchConfigurationException(build.getBranch().getName());
        }
        ConfiguredBuildSvnRevisionLink revisionLink = this.buildSvnRevisionLinkService.getConfiguredBuildSvnRevisionLink(((SVNBranchConfigurationProperty)branchConfiguration.getValue()).getBuildRevisionLink());
        return revisionLink.getBuildPath(build, (SVNBranchConfigurationProperty)branchConfiguration.getValue());
    }

    public SVNRepository getSVNRepository(Branch branch) {
        return this.svnService.getRequiredSVNRepository(branch);
    }
}

