/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.resource;

import java.util.List;
import net.nemerosa.ontrack.extension.svn.SVNController;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.ui.resource.AbstractResourceDecorator;
import net.nemerosa.ontrack.ui.resource.Link;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@Component
public class SVNConfigurationResourceDecorator
extends AbstractResourceDecorator<SVNConfiguration> {
    private final SecurityService securityService;

    @Autowired
    public SVNConfigurationResourceDecorator(SecurityService securityService) {
        super(SVNConfiguration.class);
        this.securityService = securityService;
    }

    public SVNConfiguration decorateBeforeSerialization(SVNConfiguration bean) {
        return bean.obfuscate();
    }

    public List<Link> links(SVNConfiguration configuration, ResourceContext resourceContext) {
        boolean globalSettingsGranted = this.securityService.isGlobalFunctionGranted(GlobalSettings.class);
        return resourceContext.links().self((Object)((SVNController)((Object)MvcUriComponentsBuilder.on(SVNController.class))).getConfiguration(configuration.getName())).link("_update", (Object)((SVNController)((Object)MvcUriComponentsBuilder.on(SVNController.class))).updateConfigurationForm(configuration.getName())).link("_delete", (Object)((SVNController)((Object)MvcUriComponentsBuilder.on(SVNController.class))).deleteConfiguration(configuration.getName())).link("_indexation", (Object)((SVNController)((Object)MvcUriComponentsBuilder.on(SVNController.class))).getLastRevisionInfo(configuration.getName()), globalSettingsGranted).link("_indexationFromLatest", (Object)((SVNController)((Object)MvcUriComponentsBuilder.on(SVNController.class))).indexFromLatest(configuration.getName()), globalSettingsGranted).link("_indexationFull", (Object)((SVNController)((Object)MvcUriComponentsBuilder.on(SVNController.class))).full(configuration.getName()), globalSettingsGranted).build();
    }
}

