/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.property;

import net.nemerosa.ontrack.extension.scm.property.AbstractSCMChangeLogIssueValidator;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogIssue;
import net.nemerosa.ontrack.extension.svn.model.SVNHistory;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;

public abstract class AbstractSVNChangeLogIssueValidator<T>
extends AbstractSCMChangeLogIssueValidator<T, SVNRepository, SVNHistory, SVNChangeLogIssue> {
    private final PropertyService propertyService;

    public AbstractSVNChangeLogIssueValidator(ExtensionFeature extensionFeature, PropertyService propertyService) {
        super(extensionFeature);
        this.propertyService = propertyService;
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        Branch branch = (Branch)entity;
        return securityService.isProjectFunctionGranted((ProjectEntity)branch, ProjectConfig.class) && this.canApplyTo(branch);
    }

    protected boolean canApplyTo(Branch branch) {
        return this.propertyService.hasProperty((ProjectEntity)branch.getProject(), SVNProjectConfigurationPropertyType.class) && this.propertyService.hasProperty((ProjectEntity)branch, SVNBranchConfigurationPropertyType.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }
}

