/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.UserPasswordConfiguration;
import org.apache.commons.lang3.StringUtils;

public class SVNConfiguration
implements UserPasswordConfiguration<SVNConfiguration> {
    private final String name;
    private final String url;
    private final String user;
    private final String password;
    private final String tagFilterPattern;
    private final String browserForPath;
    private final String browserForRevision;
    private final String browserForChange;
    private final int indexationInterval;
    private final long indexationStart;
    private final String issueServiceConfigurationIdentifier;

    public static SVNConfiguration of(String name, String url) {
        return new SVNConfiguration(name, url, null, null, "", "", "", "", 0, 1L, null);
    }

    public static Form form(List<IssueServiceConfigurationRepresentation> availableIssueServiceConfigurations) {
        return Form.create().with((Field)Form.defaultNameField()).with((Field)((Text)Text.of((String)"url").label("URL")).help("URL to the root of a SVN repository")).with((Field)((Text)((Text)Text.of((String)"user").label("User")).length(16)).optional()).with((Field)((Password)((Password)Password.of((String)"password").label("Password")).length(40)).optional()).with((Field)((Text)((Text)((Text)Text.of((String)"tagFilterPattern").label("Tag filter pattern")).length(100)).optional()).help("Regular expression applied to tag names. Any tag whose name matches will be excluded from the tags. By default, no tag is excluded.")).with((Field)((Text)((Text)((Text)Text.of((String)"browserForPath").label("Browsing URL for a path")).length(400)).optional()).help("URL that defines how to browse to a path. The path is relative to the repository root and must be parameterized as {path} in the URL.")).with((Field)((Text)((Text)((Text)Text.of((String)"browserForRevision").label("Browsing URL for a revision")).length(400)).optional()).help("URL that defines how to browse to a revision. The revision must be parameterized as {revision} in the URL.")).with((Field)((Text)((Text)((Text)Text.of((String)"browserForChange").label("Browsing URL for a change")).length(400)).optional()).help("URL that defines how to browse to the changes of a path at a given revision. The revision must be parameterized as {revision} in the URL and the path as {path}.")).with((Field)((Int)((Int)Int.of((String)"indexationInterval").label("Indexation interval")).min(0).max(1440).value((Object)0)).help("Interval (in minutes) between each indexation of the Subversion repository. A zero value indicates that no indexation must take place automatically and they have to be triggered manually.")).with((Field)((Int)((Int)Int.of((String)"indexationStart").label("Indexation start")).min(1).value((Object)1)).help("Revision to start the indexation from.")).with((Field)((Selection)((Selection)((Selection)Selection.of((String)"issueServiceConfigurationIdentifier").label("Issue configuration")).help("Select an issue service that is sued to associate tickets and issues to the source.")).optional()).items(availableIssueServiceConfigurations));
    }

    public SVNConfiguration obfuscate() {
        return new SVNConfiguration(this.name, this.url, this.user, "", this.tagFilterPattern, this.browserForPath, this.browserForRevision, this.browserForChange, this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public Form asForm(List<IssueServiceConfigurationRepresentation> availableIssueServiceConfigurations) {
        return SVNConfiguration.form(availableIssueServiceConfigurations).with((Field)((Text)Form.defaultNameField().readOnly()).value((Object)this.name)).fill("url", (Object)this.url).fill("user", (Object)this.user).fill("password", (Object)"").fill("tagFilterPattern", (Object)this.tagFilterPattern).fill("browserForPath", (Object)this.browserForPath).fill("browserForRevision", (Object)this.browserForRevision).fill("browserForChange", (Object)this.browserForChange).fill("indexationInterval", (Object)this.indexationInterval).fill("indexationStart", (Object)this.indexationStart).fill("issueServiceConfigurationIdentifier", (Object)this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withPassword(String password) {
        return new SVNConfiguration(this.name, this.url, this.user, password, this.tagFilterPattern, this.browserForPath, this.browserForRevision, this.browserForChange, this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public ConfigurationDescriptor getDescriptor() {
        return new ConfigurationDescriptor(this.name, this.name);
    }

    public String getUrl(String path) {
        return StringUtils.stripEnd((String)this.url, (String)"/") + "/" + StringUtils.stripStart((String)path, (String)"/");
    }

    public String getRevisionBrowsingURL(long revision) {
        if (StringUtils.isNotBlank((CharSequence)this.browserForRevision)) {
            return this.browserForRevision.replace("{revision}", String.valueOf(revision));
        }
        return String.valueOf(revision);
    }

    public String getPathBrowsingURL(String path) {
        if (StringUtils.isNotBlank((CharSequence)this.browserForPath)) {
            return this.browserForPath.replace("{path}", path);
        }
        return path;
    }

    public String getFileChangeBrowsingURL(String path, long revision) {
        if (StringUtils.isNotBlank((CharSequence)this.browserForChange)) {
            return this.browserForChange.replace("{path}", path).replace("{revision}", String.valueOf(revision));
        }
        return path;
    }

    public SVNConfiguration clone(String targetConfigurationName, Function<String, String> replacementFunction) {
        return new SVNConfiguration(targetConfigurationName, replacementFunction.apply(this.url), replacementFunction.apply(this.user), this.password, replacementFunction.apply(this.tagFilterPattern), replacementFunction.apply(this.browserForPath), replacementFunction.apply(this.browserForRevision), replacementFunction.apply(this.browserForChange), this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTagFilterPattern() {
        return this.tagFilterPattern;
    }

    public String getBrowserForPath() {
        return this.browserForPath;
    }

    public String getBrowserForRevision() {
        return this.browserForRevision;
    }

    public String getBrowserForChange() {
        return this.browserForChange;
    }

    public int getIndexationInterval() {
        return this.indexationInterval;
    }

    public long getIndexationStart() {
        return this.indexationStart;
    }

    public String getIssueServiceConfigurationIdentifier() {
        return this.issueServiceConfigurationIdentifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNConfiguration)) {
            return false;
        }
        SVNConfiguration other = (SVNConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tagFilterPattern = this.getTagFilterPattern();
        String other$tagFilterPattern = other.getTagFilterPattern();
        if (this$tagFilterPattern == null ? other$tagFilterPattern != null : !this$tagFilterPattern.equals(other$tagFilterPattern)) {
            return false;
        }
        String this$browserForPath = this.getBrowserForPath();
        String other$browserForPath = other.getBrowserForPath();
        if (this$browserForPath == null ? other$browserForPath != null : !this$browserForPath.equals(other$browserForPath)) {
            return false;
        }
        String this$browserForRevision = this.getBrowserForRevision();
        String other$browserForRevision = other.getBrowserForRevision();
        if (this$browserForRevision == null ? other$browserForRevision != null : !this$browserForRevision.equals(other$browserForRevision)) {
            return false;
        }
        String this$browserForChange = this.getBrowserForChange();
        String other$browserForChange = other.getBrowserForChange();
        if (this$browserForChange == null ? other$browserForChange != null : !this$browserForChange.equals(other$browserForChange)) {
            return false;
        }
        if (this.getIndexationInterval() != other.getIndexationInterval()) {
            return false;
        }
        if (this.getIndexationStart() != other.getIndexationStart()) {
            return false;
        }
        String this$issueServiceConfigurationIdentifier = this.getIssueServiceConfigurationIdentifier();
        String other$issueServiceConfigurationIdentifier = other.getIssueServiceConfigurationIdentifier();
        return !(this$issueServiceConfigurationIdentifier == null ? other$issueServiceConfigurationIdentifier != null : !this$issueServiceConfigurationIdentifier.equals(other$issueServiceConfigurationIdentifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tagFilterPattern = this.getTagFilterPattern();
        result = result * 59 + ($tagFilterPattern == null ? 43 : $tagFilterPattern.hashCode());
        String $browserForPath = this.getBrowserForPath();
        result = result * 59 + ($browserForPath == null ? 43 : $browserForPath.hashCode());
        String $browserForRevision = this.getBrowserForRevision();
        result = result * 59 + ($browserForRevision == null ? 43 : $browserForRevision.hashCode());
        String $browserForChange = this.getBrowserForChange();
        result = result * 59 + ($browserForChange == null ? 43 : $browserForChange.hashCode());
        result = result * 59 + this.getIndexationInterval();
        long $indexationStart = this.getIndexationStart();
        result = result * 59 + (int)($indexationStart >>> 32 ^ $indexationStart);
        String $issueServiceConfigurationIdentifier = this.getIssueServiceConfigurationIdentifier();
        result = result * 59 + ($issueServiceConfigurationIdentifier == null ? 43 : $issueServiceConfigurationIdentifier.hashCode());
        return result;
    }

    public String toString() {
        return "SVNConfiguration(name=" + this.getName() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", tagFilterPattern=" + this.getTagFilterPattern() + ", browserForPath=" + this.getBrowserForPath() + ", browserForRevision=" + this.getBrowserForRevision() + ", browserForChange=" + this.getBrowserForChange() + ", indexationInterval=" + this.getIndexationInterval() + ", indexationStart=" + this.getIndexationStart() + ", issueServiceConfigurationIdentifier=" + this.getIssueServiceConfigurationIdentifier() + ")";
    }

    @ConstructorProperties(value={"name", "url", "user", "password", "tagFilterPattern", "browserForPath", "browserForRevision", "browserForChange", "indexationInterval", "indexationStart", "issueServiceConfigurationIdentifier"})
    public SVNConfiguration(String name, String url, String user, String password, String tagFilterPattern, String browserForPath, String browserForRevision, String browserForChange, int indexationInterval, long indexationStart, String issueServiceConfigurationIdentifier) {
        this.name = name;
        this.url = url;
        this.user = user;
        this.password = password;
        this.tagFilterPattern = tagFilterPattern;
        this.browserForPath = browserForPath;
        this.browserForRevision = browserForRevision;
        this.browserForChange = browserForChange;
        this.indexationInterval = indexationInterval;
        this.indexationStart = indexationStart;
        this.issueServiceConfigurationIdentifier = issueServiceConfigurationIdentifier;
    }

    public SVNConfiguration withUser(String user) {
        return this.user == user ? this : new SVNConfiguration(this.name, this.url, user, this.password, this.tagFilterPattern, this.browserForPath, this.browserForRevision, this.browserForChange, this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withTagFilterPattern(String tagFilterPattern) {
        return this.tagFilterPattern == tagFilterPattern ? this : new SVNConfiguration(this.name, this.url, this.user, this.password, tagFilterPattern, this.browserForPath, this.browserForRevision, this.browserForChange, this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withBrowserForPath(String browserForPath) {
        return this.browserForPath == browserForPath ? this : new SVNConfiguration(this.name, this.url, this.user, this.password, this.tagFilterPattern, browserForPath, this.browserForRevision, this.browserForChange, this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withBrowserForRevision(String browserForRevision) {
        return this.browserForRevision == browserForRevision ? this : new SVNConfiguration(this.name, this.url, this.user, this.password, this.tagFilterPattern, this.browserForPath, browserForRevision, this.browserForChange, this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withBrowserForChange(String browserForChange) {
        return this.browserForChange == browserForChange ? this : new SVNConfiguration(this.name, this.url, this.user, this.password, this.tagFilterPattern, this.browserForPath, this.browserForRevision, browserForChange, this.indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withIndexationInterval(int indexationInterval) {
        return this.indexationInterval == indexationInterval ? this : new SVNConfiguration(this.name, this.url, this.user, this.password, this.tagFilterPattern, this.browserForPath, this.browserForRevision, this.browserForChange, indexationInterval, this.indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withIndexationStart(long indexationStart) {
        return this.indexationStart == indexationStart ? this : new SVNConfiguration(this.name, this.url, this.user, this.password, this.tagFilterPattern, this.browserForPath, this.browserForRevision, this.browserForChange, this.indexationInterval, indexationStart, this.issueServiceConfigurationIdentifier);
    }

    public SVNConfiguration withIssueServiceConfigurationIdentifier(String issueServiceConfigurationIdentifier) {
        return this.issueServiceConfigurationIdentifier == issueServiceConfigurationIdentifier ? this : new SVNConfiguration(this.name, this.url, this.user, this.password, this.tagFilterPattern, this.browserForPath, this.browserForRevision, this.browserForChange, this.indexationInterval, this.indexationStart, issueServiceConfigurationIdentifier);
    }
}

